package se.kth.anderslm.service;

import java.util.Timer;
import java.util.TimerTask;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.util.Log;

/**
 * A simple example on an unbound Service intended to run some work 
 * in the background. A java.util.Timmer is used (instead of a thread)
 * for the (imaginary) task.
 * The background task will run infinitely, if not explicitly stopped.
 * All messages are logged via by Log.i; use Logcat to display output.
 */
public class ExampleService extends Service {

	private final int INTERVAL = 2000;
	private Timer timer;;

	@Override
	public void onCreate() {
		super.onCreate();
		Log.i("ServiceExample", "onCreate");
	}

	@Override
	public void onStart(Intent intent, int startid) {
		doSomeWorkInBackround();
		Log.i("ServiceExample", "onStartCommand");
	}
	
    public int onStartCommand(Intent intent, int flags, int startId) {        
		doSomeWorkInBackround();
		Log.i("ServiceExample", "onStartCommand");    
    	// We want this service to continue running until it is explicitly        
    	// stopped, so return sticky.        
    	return START_STICKY;    
    }

	@Override
	public void onDestroy() {
		super.onDestroy();
		Log.i("ServiceExample", "onDestroy");
		stopWorkingInBackground();
	}
	
	@Override
	public IBinder onBind(Intent intent) {
		// Clients may not bind to this service
		return null;
	}

	private void doSomeWorkInBackround() {
		if(timer == null) {
			timer = new Timer();
			timer.scheduleAtFixedRate(new Task(), 0, INTERVAL);
		}
	}

	private void stopWorkingInBackground() {
		// Stop threads and alike, release resources
		if (timer != null) {
			timer.cancel();
		}
	}
	
	private class Task extends TimerTask {
		public void run() {
			// Do whatever you want to do every INTERVAL
			Log.i("ServiceExample", "Working in the background...");
		}
	}
}
