package se.kth.anderslm.implicit;

import android.app.Activity;
import android.app.SearchManager;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;

public class MyActivity extends Activity {
	
	private Button 	browseButton,
					emergencyButton,
					findButton;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.i("IntentTest", "MainActivity.onCreate");
        setContentView(R.layout.main);
        
        browseButton = (Button) findViewById(R.id.BrowseButton);
        browseButton.setOnClickListener(new OnBrowserButtonClick());
        emergencyButton = (Button) findViewById(R.id.DialButton);
        emergencyButton.setOnClickListener(new OnEmergencyButtonClick());
        findButton = (Button) findViewById(R.id.FindContactButton);
        findButton.setOnClickListener(new OnFindContactButtonClick());
    }
    
    private class OnEmergencyButtonClick implements View.OnClickListener {

		public void onClick(View v) {
			Intent intent = new Intent(
					Intent.ACTION_DIAL,
					Uri.parse("tel:112"));
			startActivity(intent);
		}
    }
    
    private class OnFindContactButtonClick implements View.OnClickListener {

		public void onClick(View v) {
			Intent intent = new Intent(
					Intent.ACTION_VIEW,
					Uri.parse("content://contacts/people/"));
			startActivity(intent);
		}
    }
    
    private class OnBrowserButtonClick implements View.OnClickListener {

		public void onClick(View v) {
			String query = "android";// Retrieve from TextEdit...
			Intent intent = new Intent(
					Intent.ACTION_WEB_SEARCH);
			intent.putExtra(SearchManager.QUERY, query);
			startActivity(intent);
		}
    }
}