package se.kth.anderslm.deviceorientation;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.util.AttributeSet;
import android.view.View;

public class CompassView extends View {

	public CompassView(Context context, AttributeSet attrs) {
	    super(context, attrs);
	    
		paint = new Paint();
		paint.setColor(Color.RED);
		paint.setStyle(Style.STROKE);
		paint.setStrokeWidth(4.0F);
	}

	
	public CompassView(Context context) {
		this(context, null);
	}
	
	/**
	 * @param azimuth, in radians
	 */
	protected void setAzimuth(float azimuth) {
		this.azimuth = azimuth; 
	}
	

	@Override
	protected void onDraw(Canvas canvas) {
		// Current size of this view
		int w = this.getWidth(), h = this.getHeight();
		float d = Math.min(w, h);
		float radius = d/2.0F;
		float cx = w/2.0F, cy = h/2.0F;
		canvas.drawCircle(cx, cy, radius, paint);
		
		// draw a line, direction based on azimuth
		float dx = radius * (float) Math.sin(-azimuth);
		float dy = radius * (float) Math.cos(-azimuth);
		canvas.drawLine(cx, cy, cx+dx, cy-dy, paint);
	}
	
	private float azimuth; // rad
	private Paint paint;
}
