package se.kth.anderslm.deviceorientation;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.Menu;
import android.widget.TextView;

public class MainActivity extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		azimuthView = (TextView) findViewById(R.id.textViewAzimut);
		pitchView = (TextView) findViewById(R.id.textViewPitch);
		rollView = (TextView) findViewById(R.id.textViewRoll);
		compassView = (CompassView) findViewById(R.id.compassView);

		manager = (SensorManager) getSystemService(Context.SENSOR_SERVICE);
		accSensor = manager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER);
		magneticSensor = manager.getDefaultSensor(Sensor.TYPE_MAGNETIC_FIELD);
	}

	@Override
	protected void onPause() {
		super.onPause();
		manager.unregisterListener(accMagneticListener);
	}

	@Override
	protected void onResume() {
		super.onResume();
		manager.registerListener(accMagneticListener, accSensor,
				SensorManager.SENSOR_DELAY_UI);
		manager.registerListener(accMagneticListener, magneticSensor,
				SensorManager.SENSOR_DELAY_NORMAL);
	}

	private final SensorEventListener accMagneticListener = new SensorEventListener() {

		@Override
		public void onSensorChanged(SensorEvent event) {
			if (event.sensor.getType() == Sensor.TYPE_ACCELEROMETER) {
				accValues = event.values;
				Log.i("SensorListener", "got acc data");
			} else if (event.sensor.getType() == Sensor.TYPE_MAGNETIC_FIELD) {
				magneticValues = event.values;
				Log.i("SensorListener", "got magnetic data");
			}
			calculateOrientation();
			
		}

		@Override
		public void onAccuracyChanged(Sensor sensor, int accuracy) {
		}
	};

	private void calculateOrientation() {
		if (accValues != null && magneticValues != null) {
			// calculate the rotation of the device 
			// ref: http://developer.android.com/guide/topics/sensors/sensors_position.html
			SensorManager.getRotationMatrix(rotation, null, accValues,
					magneticValues);
			SensorManager.getOrientation(rotation, radValues);
			// rad to degrees
			for (int i = 0; i < radValues.length; i++) {
				degreeValues[i] = (float) Math.toDegrees(radValues[i]);
			}
			azimuthView.setText("Azimut " + degreeValues[0]);
			pitchView.setText("Pitch " + degreeValues[1]);
			rollView.setText("Roll " + degreeValues[2]);
			
			// update the compass view
			compassView.setAzimuth(radValues[0]);
			compassView.invalidate();
		}
	}

	private SensorManager manager;
	private Sensor accSensor, magneticSensor;
	private float[] accValues, magneticValues;
	private float[] radValues = new float[3], degreeValues = new float[3],
			rotation = new float[9];

	private TextView azimuthView, pitchView, rollView;
	private CompassView compassView;

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
}
