<?php
session_start();
require_once 'Entry.php';
require_once 'keys.php';
?>

<!DOCTYPE html>
<html>
    <head>
        <title><?php include 'resources/fragments/title.php' ?></title>
        <meta charset="UTF-8">
        <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
        <link rel="stylesheet" type="text/css" href="resources/css/reset.css" />
        <!--[if IE 6]><link rel="stylesheet" type="text/css" href="resources/css/ie6.css" /><![endif]-->
        <link rel="stylesheet" type="text/css" href="resources/css/responsive.css" />
        <link rel="stylesheet" type="text/css" href="resources/css/4cols.css" />
        <link rel="stylesheet" type="text/css" href="resources/css/8cols.css" />
        <link rel="stylesheet" type="text/css" href="resources/css/chat.css" />
    </head>
    <body>
        <header class="section group">
            <?php include 'resources/fragments/header.php' ?>
        </header>
        <main class="section group">
            <nav class="section group">
                <?php include 'resources/fragments/nav.php' ?>
            </nav>
            <div class="section group">
                <div class="col span_4_of_4">
                    <h1><?php include 'resources/fragments/title.php' ?></h1>
                </div>
            </div>
            <div class="section group">
                <h2 class="col span_1_of_4">Type Here</h2>
            </div>
            <form action="store-entry.php" method='post'>
                <div class="section group">
                    <div class="col span_2_of_4">
                        <label for="entry"><?php echo $_SESSION[CHAT_NICK_KEY] ?> says:</label>
                    </div>
                </div>
                <div class="section group">
                    <div class="col span_4_of_4">
                        <textarea id= "entry" rows = 5 name='msg'
                                  placeholder="Write your entry here."></textarea>
                    </div>
                </div>
                <div class="section group">
                    <div class="col span_1_of_4">
                        <input type="submit" value="Send"/>
                    </div>
                </div>
            </form>
            <form action="chat.php" method='post'>
                <div class="section group">
                    <div class="col span_1_of_4">
                        <input type="submit" value="Load Entries"/>
                    </div>
                </div>
            </form>
            <div class="section group">
                <h2 class="col span_1_of_4">Conversation</h2>
            </div>
            <div class="section group">
                <div class="col span_4_of_4">

                    <?php
                    $filename = __DIR__ . '/conversation.txt';

                    $entries = explode(";\n", file_get_contents($filename));
                    for ($i = count($entries) - 1; $i >= 0; $i--) {
                        $entry = unserialize($entries[$i]);
                        if ($entry instanceof Entry and ! $entry->isDeleted()) {
                            echo ("<p class='author'>" . $entry->getNickName() . ":</p>");
                            echo("<p class='entry'>");
                            echo(nl2br($entry->getMsg()));
                            echo ("</p>");
                            if ($entry->getNickName() === $_SESSION[CHAT_NICK_KEY]) {
                                echo("<form action='delete-entry.php'>");
                                echo("<input type='hidden' name='timestamp' value='" .
                                $entry->getTimestamp() . "'/>");
                                echo("<input type='submit' value='Delete'/>");
                                echo("</form>");
                            }
                        }
                    }
                    ?>
                </div>
            </div>
            <footer class="section group">
                <?php include 'resources/fragments/footer.php' ?>
            </footer>
        </main>
    </body>
</html>
