$(document).ready(function () {

    var baseUrl = location.href.replace("do-login.php", "");
    var writeUrl = baseUrl + "store-entry.php";
    var readUrl = baseUrl + "get-entries.php";
    var deleteUrl = baseUrl + "delete-entry.php";

    /**
     * Invoked when the Send button is clicked. Submits the current entry.
     */
    $("button#submitEntry").click(function () {
        $.post(writeUrl, $("#entry").serialize());
        $("#entry").val("");
    });

    /**
     * Invoked when the Get Entries button is clicked. Reads all entries in the 
     * conversation from server.
     */
    $("button#getEntries").click(reloadConversation);

    /**
     * Invoked when the Delete button is clicked. Submits the timestamp of the entry to be deleted.
     */
    function deleteButtonHandler() {
        $.post(deleteUrl, $(this).siblings("input").serialize());
        reloadConversation();
    }

    function reloadConversation() {
        $.getJSON(readUrl, function (entries) {
            $("#conversation").html("");
            for (var i = 0; i < entries.length; i++) {
                addEntry(entries[i]);
            }
        });
    }

    function addEntry(entry) {
        $("<p class='author'>" + removeQuotes(entry.nickName) + ":</p>").appendTo($("#conversation"));
        $("<p class='entry'>" + nl2br(removeQuotes(entry.msg)) + "</p>").appendTo($("#conversation"));
        if (removeQuotes(entry.nickName) === removeQuotes(getNickName())) {
            var deleteParagraph = $("<p class='delete'></p>");
            $("<input type='hidden' name='timestamp' value='" +
                    entry.timestamp + "'/>").appendTo(deleteParagraph);
            $("<button>Delete</button>").click(deleteButtonHandler).appendTo(deleteParagraph);
            $(deleteParagraph).appendTo("#conversation");
        }
    }

    /**
     * Removes double quotes from the specified string.
     * 
     * @param {String} str The string from which to remove quotes.
     * @returns {String} 'str', without double quotes.
     */
    function removeQuotes(str) {
        return str.replace(/\"/g, "");
    }

    /**
     * Finds the current user's nick name from the DOM tree.
     * 
     * @returns {String} The current user's nick name.
     */
    function getNickName() {
        var nickNameLabelTail = " says:";
        return removeTrailingString($("#nickNameLabel").text(), nickNameLabelTail);
    }

    /**
     * If 'fullString' ends with 'tailToRemove', return 'fullString' without 'tailToRemove'.
     * If 'fullString' does not end with 'tailToRemove', return 'fullString' unchanged.
     * 
     * @param {String} fullString The string from which to remove the tail.
     * @param {String} tailToRemove The tail to remove.
     * @returns {String} The stripped fullString.
     */
    function removeTrailingString(fullString, tailToRemove) {
        if (!endsWith(fullString, tailToRemove)) {
            return fullString;
        }
        return fullString.substr(0, fullString.length - fullString.lastIndexOf(tailToRemove) - 1);
    }

    /**
     * Returns true is 'str' ends with 'tail', false if it does not.
     * 
     * @param {String} str   The string to whose tail is checked.
     * @param {Strting} tail The tail to look for. 
     * @returns {Boolean} True is 'str' ends with 'tail', false if it does not.
     */
    function endsWith(str, tail) {
        return str.lastIndexOf(tail) === str.length - tail.length;
    }

    /**
     * Replaces line breaks with '<br/>'.
     * @param {String} str The string in which to replace.
     * @returns {String} 'str', with line breaks replaced with '<br/>'.
     */
    function nl2br(str) {
        var breakTag = '<br/>';
        return str.replace(/\\r\\n|\\n\\r|\\r|\\n/g, breakTag);
    }

});
