<!DOCTYPE html>
<html>
    <head>
        <title><?php include CHAT_FRAGMENTS . 'title.php' ?></title>
        <meta charset="UTF-8">
        <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
        <link rel="stylesheet" type="text/css" href="resources/css/reset.css" />
        <!--[if IE 6]><link rel="stylesheet" type="text/css" href="resources/css/ie6.css" /><![endif]-->
        <link rel="stylesheet" type="text/css" href="resources/css/responsive.css" />
        <link rel="stylesheet" type="text/css" href="resources/css/4cols.css" />
        <link rel="stylesheet" type="text/css" href="resources/css/8cols.css" />
        <link rel="stylesheet" type="text/css" href="resources/css/chat.css" />
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
        <script type="text/javascript" src="resources/js/chat.js"></script>
    </head>
    <body>
        <header class="section group">
            <?php include CHAT_FRAGMENTS . 'header.php' ?>
        </header>
        <main class="section group">
            <nav class="section group">
                <?php include CHAT_FRAGMENTS . 'nav.php' ?>
            </nav>
            <div class="section group">
                <div class="col span_4_of_4">
                    <h1><?php include CHAT_FRAGMENTS . 'title.php' ?></h1>
                </div>
            </div>
            <div class="section group">
                <h2 class="col span_1_of_4">Type Here</h2>
            </div>
            <div class="section group">
                <div class="col span_2_of_4">
                    <label id="nickNameLabel" for="entry"><?php echo $username ?> says:</label>
                </div>
            </div>
            <div class="section group">
                <div class="col span_4_of_4">
                    <textarea id= "entry" rows = 5 name='msg'
                              placeholder="Write your entry here."></textarea>
                </div>
            </div>
            <div class="section group">
                <div class="col span_1_of_4">
                    <button id='submitEntry'>Send</button>
                </div>
            </div>
            <div class="section group">
                <div class="col span_1_of_4">
                    <button id="getEntries">Load Entries</button>
                </div>
            </div>
            <div class="section group">
                <h2 class="col span_1_of_4">Conversation</h2>
            </div>
            <div class="section group">
                <div class="col span_4_of_4" id="conversation">
                </div>
            </div>
            <footer class="section group">
                <?php include CHAT_FRAGMENTS . 'footer.php' ?>
            </footer>
        </main>
    </body>
</html>
