<?php

namespace Chat;

use Id1354fw\View\AbstractRequestHandler;
use Chat\Util\Constants;
use Chat\Model\Entry;

/**
 * Deletes the specified entry.
 *
 * @author Leif Lindback, leifl@kth.se
 */
class DeleteEntry extends AbstractRequestHandler {

    private $timestamp;

    public function setTimestamp($timestamp) {
        $this->timestamp = $timestamp;
    }

    protected function doExecute() {
        $contr = $this->session->get(Constants::CHAT_CONTR_KEY);

        $contr->deleteEntry((integer) $this->timestamp);

        $this->session->set(Constants::CHAT_CONTR_KEY, $contr);
    }

}