<?php

namespace Chat;

use Chat\Util\Constants;
use Id1354fw\View\AbstractRequestHandler;

/**
 * Returns a JSON array with all entries newer than the specified timestamp.
 *
 * @author Leif Lindback, leifl@kth.se
 */
class GetEntries extends AbstractRequestHandler {

    private $timestamp;

    /**
     * @param string $timestamp The highest timestamp of all entries known by the client.
     */
    public function setTimestamp($timestamp) {
        $this->timestamp = $timestamp;
    }

    protected function doExecute() {
        $contr = $this->session->get(Constants::CHAT_CONTR_KEY);

        $this->addVariable(Constants::CHAT_JSON_DATA_VAR,
                           $contr->getNewerEntries($this->timestamp, TRUE));
        $this->session->set(Constants::CHAT_CONTR_KEY, $contr);
        return Constants::CHAT_JSON_VIEW;
    }

}