<!DOCTYPE html>
<html>
    <head>
        <title><?php include Chat\Util\Constants::getViewFragmentsDir() . 'title.php' ?></title>
        <meta charset="UTF-8">
        <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
        <link rel="stylesheet" type="text/css" 
              href="<?php echo Chat\Util\Constants::getCssDir() ?>reset.css" />
        <!--[if IE 6]><link rel="stylesheet" type="text/css" 
        href="<?php echo Chat\Util\Constants::getCssDir() ?>ie6.css" /><![endif]-->
        <link rel="stylesheet" type="text/css" 
              href="<?php echo Chat\Util\Constants::getCssDir() ?>responsive.css" />
        <link rel="stylesheet" type="text/css" 
              href="<?php echo Chat\Util\Constants::getCssDir() ?>4cols.css" />
        <link rel="stylesheet" type="text/css" 
              href="<?php echo Chat\Util\Constants::getCssDir() ?>8cols.css" />
        <link rel="stylesheet" type="text/css" 
              href="<?php echo Chat\Util\Constants::getCssDir() ?>chat.css" />
        <script type="text/javascript" 
        src="https://cdnjs.cloudflare.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
        <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/knockout/3.3.0/knockout-min.js"></script>
        <script type="text/javascript" 
        src="<?php echo Chat\Util\Constants::getJsDir() ?>chat.js"></script>
    </head>
    <body>
        <header class="section group">
            <?php include Chat\Util\Constants::getViewFragmentsDir() . 'header.php' ?>
        </header>
        <main class="section group">
            <nav class="section group">
                <?php include Chat\Util\Constants::getViewFragmentsDir() . 'nav.php' ?>
            </nav>
            <div class="section group">
                <div class="col span_4_of_4">
                    <h1><?php include Chat\Util\Constants::getViewFragmentsDir() . 'title.php' ?></h1>
                </div>
            </div>
            <div class="section group">
                <h2 class="col span_1_of_4">Type Here</h2>
            </div>
            <div id="new-entry">
                <div class="section group">
                    <div class="col span_2_of_4">
                        <label id="nickNameLabel" for="entry">
                            <span data-bind="text: nickName"></span> says:
                        </label>
                    </div>
                </div>
                <div class="section group">
                    <div class="col span_4_of_4">
                        <textarea id= "entry" rows = 5
                                  data-bind="textInput: msg"
                                  placeholder="Write your entry here."></textarea>
                    </div>
                </div>
                <div class="section group">
                    <div class="col span_1_of_4">
                        <button data-bind="click: sendEntry">Send</button>
                    </div>
                </div>
            </div>
            <div id="conversation">
                <div class="section group">
                    <div class="col span_1_of_4">
                        <button data-bind="click: getNewEntries">Load Entries</button>
                    </div>
                </div>
                <div class="section group">
                    <h2 class="col span_1_of_4">Conversation</h2>
                </div>
                <div class="section group">
                    <div class="col span_4_of_4">
                        <!-- ko foreach: {data: entries, as: 'entry'} -->
                            <p class='author'>
                                <span data-bind="text: entry.nickName"></span>: 
                            </p>
                            <!-- ko foreach: entry.msg -->
                                <p class='entry'>
                                    <span data-bind="text: $data"></span>
                                </p>
                            <!-- /ko -->
                            <!-- ko if: entry.iWroteThisEntry -->
                                <p class='delete'>
                                    <button data-bind="click: $parent.deleteEntry">
                                        Delete
                                    </button>
                                </p>
                            <!-- /ko -->
                        <!-- /ko -->
                    </div>
                </div>
            </div>
            <footer class="section group">
                <?php include Chat\Util\Constants::getViewFragmentsDir() . 'footer.php' ?>
            </footer>
        </main>
    </body>
</html>
