<?php

namespace Chat;

use Chat\Util\Constants;
use Id1354fw\View\AbstractRequestHandler;

/**
 * Returns the username of the user in the current session.
 *
 * @author Leif Lindback, leifl@kth.se
 */
class GetUsername extends AbstractRequestHandler {

    protected function doExecute() {
        $contr = $this->session->get(Constants::CHAT_CONTR_KEY);

        $this->addVariable(Constants::CHAT_JSON_DATA_VAR,
                           $contr->getUsername());
        $this->session->set(Constants::CHAT_CONTR_KEY, $contr);
        return Constants::CHAT_JSON_VIEW;
    }

}