<?php

namespace Chat;

use Id1354fw\View\AbstractRequestHandler;
use Chat\Controller\Controller;
use Chat\Util\Constants;

/**
 * There is no authentication, this class just stores the user's nickname and shows the
 * chat conversation.
 *
 * @author Leif Lindback, leifl@kth.se
 */
class Login extends AbstractRequestHandler {

    private $nickName;

    public function setNickName($nickName) {
        $this->nickName = $nickName;
    }

    protected function doExecute() {
        $contr = new Controller();

        $contr->login($this->nickName);
        $this->addVariable(Constants::CHAT_USERNAME_VAR, $contr->getUsername());

        $this->session->set(Constants::CHAT_CONTR_KEY, $contr);
        return Constants::CHAT_CONVERSATION_VIEW;
    }

}