<?php

namespace Chat\Model;

/**
 * Holds one entry in the conversation.
 */
class Entry implements \JsonSerializable {

    private $nick_name;
    private $msg;
    private $timestamp;
    private $deleted;

    /**
     * Constructs a new, not deleted, entry with the timestamp set to the time when this constructor is called.
     */
    public function __construct($nick_name, $msg) {
        $this->nick_name = $nick_name;
        $this->msg = $msg;
        $this->timestamp = time();
        $this->deleted = false;
    }

    /**
     * @return string The author's nick name.
     */
    public function getNickName() {
        return $this->nick_name;
    }

    /**
     * @return string The message.
     */
    public function getMsg() {
        return $this->msg;
    }

    /**
     * @return int The time (on the server) when this entry was created.
     */
    public function getTimestamp() {
        return $this->timestamp;
    }

    /**
     * @return boolean True if the entry has been deleted.
     */
    public function isDeleted() {
        return $this->deleted;
    }

    /**
     * @param boolean $deleted Set to true if the entry shall be deleted.
     */
    public function setDeleted($deleted) {
        $this->deleted = $deleted;
    }

    /**
     * Create a JSON representation of this object.
     * 
     * @return \StdClass An object of an anonymous class that contains the 'nickName', 'msg' 
     *                    and 'timestamp' properties of this object and can be encoded 
     *                    with \json_encode. 
     */
    public function jsonSerialize() {
        $json_obj = new \stdClass;
        $json_obj->nickName = \json_encode($this->nick_name);
        $json_obj->msg = \json_encode($this->msg, JSON_UNESCAPED_UNICODE);
        $json_obj->timestamp = \json_encode($this->timestamp);
        return $json_obj;
    }

}