<?php

namespace Chat;

use Id1354fw\View\AbstractRequestHandler;
use Chat\Util\Constants;
use Chat\Model\Entry;

/**
 * Stores the specified entry in the conversation. No Http response is sent.
 *
 * @author Leif Lindback, leifl@kth.se
 */
class StoreEntry extends AbstractRequestHandler {

    private $msg;

    public function setMsg($msg) {
        $this->msg = $msg;
    }

    protected function doExecute() {
        $contr = $this->session->get(Constants::CHAT_CONTR_KEY);

        $contr->addEntry(new Entry($contr->getUsername(), $this->msg));

        $this->session->set(Constants::CHAT_CONTR_KEY, $contr);
    }

}