$(document).ready(function () {

    var baseUrl = location.href.replace("Login", "");
    var nickNameUrl = baseUrl + "GetUsername";
    var writeUrl = baseUrl + "StoreEntry";
    var readUrl = baseUrl + "GetEntries";
    var deleteUrl = baseUrl + "DeleteEntry";

    function EntryToAdd() {
        var self = this;
        self.nickName = ko.observable();
        self.msg = ko.observable("");

        self.sendEntry = function () {
            if (self.msg() !== "") {
                $.post(writeUrl, "msg=" + ko.toJS(self.msg));
                self.msg("");
            }
        };
        
        $.getJSON(nickNameUrl, function(username) {
           self.nickName(username); 
        });
    }

    function Conversation(entryToAdd) {
        var self = this;
        self.entryToAdd = entryToAdd;
        self.lastSeenTimestamp = 0;
        self.entries = ko.observableArray();
        
        self.getNewEntries = function () {
            $.getJSON(readUrl, "timestamp=" + self.lastSeenTimestamp, function (jsonEntries) {
                for (var i = jsonEntries.length - 1; i >=0; i--) {
                    var entry = jsonEntries[i];
                    if (entry.timestamp > self.lastSeenTimestamp) {
                        self.lastSeenTimestamp =entry.timestamp;
                    }
                    entry.nickName = removeQuotes(entry.nickName);
                    entry.msg = removeQuotes(entry.msg).split("\\n");
                    entry.iWroteThisEntry = entry.nickName === self.entryToAdd.nickName();
                    self.entries.unshift(entry);
                }
                self.getNewEntries();
            });
        };
        
        self.deleteEntry = function(entry) {
            self.entries.remove(entry);
            $.post(deleteUrl, "timestamp=" + ko.toJS(entry.timestamp));
        };
        
        self.getNewEntries();
    }

    /**
     * Removes double quotes from the specified string.
     * 
     * @param {String} str The string from which to remove quotes.
     * @returns {String} 'str', without double quotes.
     */
    function removeQuotes(str) {
        return str.replace(/\"/g, "");
    }

    var entryToAdd = new EntryToAdd();
    ko.applyBindings(entryToAdd, document.getElementById('new-entry'));
    ko.applyBindings(new Conversation(entryToAdd), document.getElementById('conversation'));
});

