%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% Evaluation of the accuracy of the measurement provided by the camera 
% 
% Method: based on a constant joint velocity, the resulting simple
% trajectory is identified. The difference between the measured and
% identified tajectories are considered as noise.
%
% benchmark on the identification of a flexible serial manipulator 
% using a camera, 
% E. Laroche, L. Cuvillon, D. Vizer and G. Mercre
% http://icube-avr.unistra.fr/en/index.php/Identification_benchmark
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all

FontSize = 16;
FigFontSize = 16;

% Data structure: [sample, ?, u1, u2, ?, ?, theta1, theta2, ?, Yx, Yy]
% - u1, u2: control signals in V
% - theta1, theta2: joint positions provider by encoders
% - Yx, Yy: measurement (pixel) of the position of a LED located at the end
% of the arm
load 'test_q1/ledq1_005.dat' % with q1 = 0.05 V
%load 'test_q1/ledq1_005v2.dat' % with q1 = 0.05 V, second version
%load 'test_q1/ledq1_01.dat' 
%load 'test_q2/ledq2_005.dat' % with q2 = 0.05 V

Data = ledq1_005;
fe = 500; Te = 1/fe;

Nm = size(Data,1);
Time = Te*Data(:,1);

%%
U = Data(:,[3 4]);
figure('Name','Control signals')
plot(Time,U,'.')
xlabel('time (s)','FontSize',FontSize)
ylabel('Control signals (V)','FontSize',FontSize)
legend('u1','u2','FontSize',FontSize)

%%
Theta = Data(:,[7 8]); % joint positions
DTheta = Theta(2:Nm,:)-Theta(1:Nm-1,:);
DThetaSort = sort(DTheta);
figure('Name','Erreur codeur')
%plot(Time(1:Nm-1),DThetaSort,'.')
plot(DThetaSort,'.')
xlabel('sample','FontSize',FontSize)
ylabel('gap between two measurements','FontSize',FontSize)
legend('q1','q2','FontSize',FontSize)
DeltaTheta = mean(DThetaSort(2100:4000)) % = 1.5340e-05

%%
Y = Data(:,[10 11]);
% Identification of models 
% x = px1*t^(Np-1) + px{Np-1}*t + px{Np} and
% y = py1*t^(Np-1) + py{Np-1}*t + py{Np}
N1 = 200;
Np = 9;
R = Time(N1:Nm).^(Np-1);
for Ind = Np-2:-1:0,
    R = [R, Time(N1:Nm).^Ind];
end
Bx = Y(N1:Nm,1); 
Px = pinv(R)*Bx;
Px2 = lsqlin(R,Bx);
[Px Px2]
By = Y(N1:Nm,2); 
Py = pinv(R)*By;
Py2 = lsqlin(R,By);
[Py Py2]

Ye = 0;
for Ind = 1:Np,
    Ye = Ye + [Px(Ind)*Time.^(Np-Ind) Py(Ind)*Time.^(Np-Ind)];
end
%Ye = [Px(1)*Time.^5+Px(1)*Time.^4+Px(1)*Time.^3+Px(2)*Time.^2+Px(3)*Time+Px(4), ...
%    Py(1)*Time.^5+Py(1)*Time.^4+Py(1)*Time.^3+Py(2)*Time.^2+Py(3)*Time+Py(4)];

figure('Name','Histogram')
Tab = [-0.5:0.05:0.5]; 
subplot(2,1,1)
hist(Y(N1:Nm,1) - Ye(N1:Nm,1),Tab)
xlabel('$z_1$ (pix)','Interpreter','latex','FontSize',FontSize);
set(gca,'FontSize',FigFontSize)
xlim([min(Tab) max(Tab)])
ylim([0 1600])

subplot(2,1,2)
hist(Y(N1:Nm,2) - Ye(N1:Nm,2),Tab)
%FigPosition = [1 scrsz(4)/2 scrsz(3)/2 scrsz(4)/3];
%plot(Time,theta2,'LineWidth',1.5)
%xlim([Time(1) Time(end)]);
xlim([min(Tab) max(Tab)])
xlabel('$z_2$ (pix)','Interpreter','latex','FontSize',FontSize);
%grid on
set(gca,'FontSize',FigFontSize)
if 0,
    saveas(gca,'HistErrImage_theta2_t.fig')
    print -deps 'HistErrImage_theta2_t.eps'; 
end
Stdx = std(Y(N1:Nm,1) - Ye(N1:Nm,1))
Stdy = std(Y(N1:Nm,2) - Ye(N1:Nm,2))

figure('Name','Position error in the image')
plot(Time,[Y-Ye])
xlabel('time (s)','FontSize',FontSize)
ylabel('error (pixel)','FontSize',FontSize)
legend('x','y','FontSize',FontSize)
J = 1/sqrt((Nm-N1+1))*norm(Y(N1:Nm,:)-Ye(N1:Nm,:))
