function [] = Get_Figures_LocExcit(Time,x_im,y_im,dtheta_1,dtheta_2,u1,u2,FigName,index)


FontSize = 20;
FigFontSize = 20;

%% Image velocity

%FigName = [ExportName '_u2_t'];
figure('Name',[FigName,' - image velocity'])
subplot(2,1,1)
plot(Time,x_im,'LineWidth',1.5)
xlim([Time(1) Time(end)]);
title('Image velocity','Interpreter','latex','FontSize',FontSize')
ylabel('$\dot{x}$ (pix/s)','Interpreter','latex','FontSize',FontSize')
xlabel('time $t$ (s)','Interpreter','latex','FontSize',FontSize);
grid on
set(gca,'FontSize',FigFontSize)

subplot(2,1,2)
plot(Time,y_im,'LineWidth',1.5)
xlim([Time(1) Time(end)]);
ylabel('$\dot{y}$ (pix/s)','Interpreter','latex','FontSize',FontSize')
xlabel('time $t$ (s)','Interpreter','latex','FontSize',FontSize);
grid on
set(gca,'FontSize',FigFontSize)

%saveas(gca,['Fig' ExportName '_dxdyim_t.fig'])
%eval(['print -deps Fig' ExportName '_dxdyim_t.eps']);



%% Joint velocity

figure('Name',[FigName,' - joint velocity']);
subplot(2,1,1)
plot(Time,dtheta_1,'LineWidth',1.5)
xlim([Time(1) Time(end)]);
ylabel('$\dot{\theta_1}$ (rad/s)','Interpreter','latex','FontSize',FontSize')
xlabel('time $t$ (s)','Interpreter','latex','FontSize',FontSize);
grid on
set(gca,'FontSize',FigFontSize)

subplot(2,1,2)
plot(Time,dtheta_2,'LineWidth',1.5)
xlim([Time(1) Time(end)]);
ylabel('$\dot{\theta_2}$ (rad/s)','Interpreter','latex','FontSize',FontSize')
xlabel('time $t$ (s)','Interpreter','latex','FontSize',FontSize);
grid on
set(gca,'FontSize',FigFontSize)

%saveas(gca,['Fig' ExportName '_dtheta_12_t.fig'])
%eval(['print -deps Fig' ExportName '_dtheta_12_t.eps']);


%% Input signals

figure('Name',[FigName,' - input']);
subplot(2,1,1)
plot(Time,u1,'LineWidth',1.5)
xlim([Time(1) Time(end)]);
ylabel('$u_1$ (V)','Interpreter','latex','FontSize',FontSize')
xlabel('time $t$ (s)','Interpreter','latex','FontSize',FontSize);
grid on
set(gca,'FontSize',FigFontSize)

subplot(2,1,2)
plot(Time,u2,'LineWidth',1.5)
xlim([Time(1) Time(end)]);
ylabel('$u_2$ (V)','Interpreter','latex','FontSize',FontSize')
xlabel('time $t$ (s)','Interpreter','latex','FontSize',FontSize);
grid on
set(gca,'FontSize',FigFontSize)

% if index == 1
%     saveas(gca,['Fig' ExportName '_u12_t.fig'])
%     eval(['print -deps Fig' ExportName '_u12_t.eps']);
% end

