% Data visualisation
% A benchmark on the identification of a flexible serial manipulator
% using a camera for testing MIMO LPV approaches
% E. Laroche, L. Cuvillon, D. Vizer and G. Mercre, 2015

%% General menu
Choice0 = menu('General Menu','Local excitation','Global excitation','exit');
switch Choice0,
    
    %% Local Excitations
    case 1,
        disp('LOCAL EXCITATIONS')
        FileNameList = {'local_limited','local0.25_','local'};
        MenuList1 = {'rate-limited PRBS','0.25 V PRBS','0.5 V PRBS'};
        Choice1 = menu('Select the kind of local experiment',MenuList1);
        NumList = {'First set','Second set'};
        MenuList2 = {'1','2'};
        Choice2 = menu('Select the data set number',NumList);
        Choice3 = menu('local position for q2 (rad)','2/16*pi','3/16*pi',...
            '4/16*pi','5/16*pi','6/16*pi','7/16*pi','8/16*pi','9/16*pi',...
            '10/16*pi','11/16*pi','12/16*pi');
        
        g = 0.2; % conversion between V and rad/s for input
        
        fichier = ['../LocalData/',FileNameList{Choice1},...
            num2str(Choice3),'_',MenuList2{Choice2},'.dat'];
        filename = [FileNameList{Choice1},num2str(Choice3),'_',...
            MenuList2{Choice2}];
        Te = 1/500; % sample time en second
        
        Scale_Input
        
        data = load(fichier);
        
        Make_Outputs
        disp(['q2 = ',num2str(pos_cod(1,2))])
        
        Y = [vit_im vit_cod]; % pos_im, image position
        U = [U1 U2];
        
        % input signals
        u1 = U1;
        u2 = U2;
        
        % image velocities
        x_im = vit_im(:,1);
        y_im = vit_im(:,2);
        
        % joint velocities
        dtheta_1 = vit_cod(:,1);
        dtheta_2 = vit_cod(:,2);
        
        Make_Figures_LocExcit(Time,x_im,y_im,dtheta_1,dtheta_2,u1,u2,filename,Choice3)
        

    %% Global Excitations
    case 2,
        disp('GLOBAL EXCITATIONS')
        FileNameList = {'global1_1','global1_2','global1limited_1',...
            'global1limited_2','global2_1','global2_2',...
            'global2_1_limited','global2_2_limited'};
        MenuList = {'PRBS + fast chirp #1','PRBS + fast chirp #2',...
            'rate limited PRBS + fast chirp #1','rate limited PRBS + fast chirp #2',...
            'PRBS + slow chirp with small PRBS #1','PRBS + slow chirp with small PRBS #2',...
            'rate limited PRBS + slow chirp #1','rate limited PRBS + slow chirp #2'};
        Choice = menu('Select the data set',MenuList);
        FileName = FileNameList{Choice};
        
        disp(['Global excitation, ', MenuList{Choice}]);
        
        g = 0.2;
        fichier = ['../GlobalData/' FileName '.dat'];
        %filename = ['Global',num2str(index)];
        Te = 1/500;
        
        Scale_Input
        
        data = load(fichier);
        
        Make_Outputs
        
        % joint positions
        theta_1 = pos_cod(:,1);
        theta_2 = pos_cod(:,2);
        
        % joint velocities
        dtheta_1 = vit_cod(:,1);
        dtheta_2 = vit_cod(:,2);
        
        % input signals
        u1 = U1;
        u2 = U2;
        
        Make_Figures_GlobExcit(Time,u1,u2,theta_1,theta_2,dtheta_1,dtheta_2,FileName)
        
    case 3,
        break
end