function [] = Get_Figures_GlobExcit(Time,u1,u2,theta_1,theta_2,dtheta_1,dtheta_2,ExportName)

FontSize = 20;
FigFontSize = 20;

FigName = [ExportName];

%% Joint position

figure('Name',[FigName,' - joint position']);
subplot(2,1,1)
plot(Time,theta_1,'LineWidth',1.5)
xlim([Time(1) Time(end)]);
ylabel('$\theta_1$ (rad)','Interpreter','latex','FontSize',FontSize')
xlabel('time $t$ (s)','Interpreter','latex','FontSize',FontSize);
grid on
set(gca,'FontSize',FigFontSize)

subplot(2,1,2)
plot(Time,theta_2,'LineWidth',1.5)
xlim([Time(1) Time(end)]);
ylabel('$\theta_2$ (rad)','Interpreter','latex','FontSize',FontSize')
xlabel('time $t$ (s)','Interpreter','latex','FontSize',FontSize);
grid on
set(gca,'FontSize',FigFontSize)

%saveas(gca,['Fig' ExportName '_theta12_t.fig'])
%eval(['print -deps Fig' ExportName '_theta12_t.eps']);


%% Joint velocity

figure('Name',[FigName,' - joint velocity']);
subplot(2,1,1)
plot(Time,dtheta_1,'LineWidth',1.5)
xlim([Time(1) Time(end)]);
ylabel('$\dot{\theta_1}$ (rad/s)','Interpreter','latex','FontSize',FontSize')
xlabel('time $t$ (s)','Interpreter','latex','FontSize',FontSize);
grid on
set(gca,'FontSize',FigFontSize)

subplot(2,1,2)
plot(Time,dtheta_2,'LineWidth',1.5)
xlim([Time(1) Time(end)]);
ylabel('$\dot{\theta_2}$ (rad/s)','Interpreter','latex','FontSize',FontSize')
xlabel('time $t$ (s)','Interpreter','latex','FontSize',FontSize);
grid on
set(gca,'FontSize',FigFontSize)

%saveas(gca,['Fig' ExportName '_dtheta12_t.fig'])
%eval(['print -deps Fig' ExportName '_dtheta12_t.eps']);


%% Input signals

figure('Name',[FigName,' - input']);
subplot(2,1,1)
plot(Time,u1,'LineWidth',1.5)
xlim([Time(1) Time(end)]);
ylabel('$u_1$ (V)','Interpreter','latex','FontSize',FontSize')
xlabel('time $t$ (s)','Interpreter','latex','FontSize',FontSize);
grid on
set(gca,'FontSize',FigFontSize)

subplot(2,1,2)
plot(Time,u2,'LineWidth',1.5)
xlim([Time(1) Time(end)]);
ylabel('$u_2$ (V)','Interpreter','latex','FontSize',FontSize')
xlabel('time $t$ (s)','Interpreter','latex','FontSize',FontSize);
grid on
set(gca,'FontSize',FigFontSize)

%saveas(gca,['Fig' ExportName '_u12_t.fig'])
%eval(['print -deps Fig' ExportName '_u12_t.eps']);

