 % Read the Jacobian J
    F = fopen(fichier,'r');
    fgets(F);
    fgets(F);
    fgets(F,2);
    J = fscanf(F, '%f',4);
    J = reshape(J,2,2)';
    fgets(F);
    fgets(F);
  
    if J~=zeros(2), % notice that J is not available for global experiment
        Jinv = inv(J);
    else
        Jinv = zeros(2);
    end
    
    % Input signals
       U = data(:,3:4);

    % Velocity in the image (Euler)
       pos_im = data(:,10:11);
       Nq = length(pos_im(:,1));
       vit_im = zeros(Nq,2);
       vit_im(1,:) = (pos_im(2,:) - pos_im(1,:))/(Time(2)-Time(1));
       vit_im(Nq,:) = (pos_im(Nq,:) - pos_im(Nq-1,:))/(Time(Nq)-Time(Nq-1));
       for i=2:Nq-1;
           vit_im(i,:) = (pos_im(i+1,:) - pos_im(i-1,:))/(Time(i+1)-Time(i-1));
       end
       
    % Pseudo joint velocity (d_alpha/dt = inv(J)*vit_im)
       dqn = [];
       for i=1:length(data(:,1)),
           dqk = Jinv*vit_im(i,:)'; 
           dqn = [dqn; dqk'];
       end
       vit_art = dqn;
       
    % Derivatives of joint measurements
       pos_cod = data(:,7:8);
       vit_cod = zeros(Nq,2);
       vit_cod(1,:) = (pos_cod(2,:) - pos_cod(1,:))/(Time(2)-Time(1));
       vit_cod(Nq,:) = (pos_cod(Nq,:) - pos_cod(Nq-1,:))/(Time(Nq)-Time(Nq-1));
       for i=2:Nq-1;
           vit_cod(i,:) = (pos_cod(i+1,:) - pos_cod(i-1,:))/(Time(i+1)-Time(i-1));
       end
  