<?php

/**
 * Saves the user's nick name for the session.
 */

namespace Chat\View;

use \Chat\Util\Util;
use \Chat\Model\Entry;
use Chat\Controller\SessionManager;

require_once 'classes/Chat/Util/Util.php';
Util::initRequest();

if (empty($_POST[CHAT_NICK_KEY])) {
    include 'index.php';
    exit();
} else {
    $username = $_POST[CHAT_NICK_KEY];
}

$controller = SessionManager::getController();
$controller->login($username);
$entries = $controller->getConversation();
$username = $controller->getUsername();
SessionManager::storeController($controller);

include CHAT_VIEWS . 'conversation.php';
