module ControlKTH

export
        #general datatypes
        LTISystem,
        StateSpace,
        TransferFunction,
        ZPK,
        ss,
        rss,
        siso_tf_to_ss,
        tf2ss,
        SisoTf,
        ss2tf,
        tf,
        zpk,
        # Linear Algebra
        care,
        dare,
        dlyap,
        lqr,
        dlqr,
        covar,
        norm,
        gram,
        ctrb,
        acker,
        obsv,
        # Model Simplification
        sminreal,
        minreal,
        # Stability Analysis
        pole,
        tzero,
        gain,
        zpkdata,
        damp,
        dampreport,
        markovparam,
        dcgain,
        phasemargin,
        gainmargin,
        # Connections
        append,
        series,
        parallel,
        feedback,
        # Discrete
        c2d,
        # Time Response
        step,
        impulse,
        lsim,
        overshoot,
        undershoot,
        finalvalue,
        peak,
        peaktime,
        risetime,
        settingtime,
        StepInfo,
        stepinfo,
        # Frequency Response
        freqresp,
        evalfr,
        bode,
        nyquist,
        sigma,
        # System Identification
        iddata,
        iddataObject,
        etfe,
        spa,
        preprocessing,
        PEM,
        PEM2,
        idFreqResp,
        idModelOutput,
        idAkaike,
        idResid,
        idPzPlot,
        idStep,
        idImpulse,
        # Generate Random
        generate_ss,
        # Utilities
        phaseunwrap,
        phaseunwrap!,
        ssdata,
        isstable,
        iscontinuous,
        issiso,
        isproper,
        order,
        # Root locus
        rlocus


using Requires

import Base.+, Base.-, Base.*, Base./, Base.(./), Base.==, Base.(.+), Base.(.-), Base.(.*)

include("types/lti.jl")
include("types/transferfunction.jl")
include("types/statespace.jl")
include("types/zpk.jl")
include("types/tf2ss.jl")
include("types/ss2tf.jl")
include("types/iddata.jl")
include("types/idModels.jl")

# include("sys_identification/methods.jl")
# include("sys_identification/utilities.jl")
include("sys_identification/model_validation.jl")
include("sys_identification/arx.jl")
include("sys_identification/armax.jl")
include("sys_identification/oe.jl")
include("sys_identification/bj.jl")
include("generate_random.jl")
include("connections.jl")
include("discrete.jl")
include("matrix_comps.jl")
include("simplification.jl")
include("synthesis.jl")
include("analysis.jl")
include("timeresp.jl")
include("freqresp.jl")
include("utilities.jl")
include("rootlocus.jl")

# The path has to be evaluated upon initial import
const __CONTROL_SOURCE_DIR__ = dirname(Base.source_path())
@require PyPlot include(joinpath(__CONTROL_SOURCE_DIR__, "plotting.jl"))
@require DSP include("sys_identification/methods.jl")
@require ForwardDiff include("sys_identification/utilities.jl")

end
