#####################################################################
#=                     IDLinearModel
            Linear, ready-made models for SysIdent
            y(t) = G(q,theta)*u(t) + H(q,theta)e(t)

                Implementation according to

              "Modeling of Dynamical Systems"

                    by Ljung and Glad

G,H              : Transfer functions
nb,nc,nd,nf,nk   : orders
method           : e.g. "ARX",...
V                : includes the last value of the loss function while using PEM
N                : length of the effective used data to estimate PEM
res              : Residuals that arose during PEM

Author : Lars Lindemann @2015

                                                                   =#
#####################################################################

type idLinearModel
    G::TransferFunction
    H::TransferFunction
    nb::Int64
    nc::Int64
    nd::Int64
    nf::Int64
    nk::Int64
    method::ASCIIString
    V::Float64           # be careful: this is the unscaled version of V
    N::Int64

    function idLinearModel(G::TransferFunction,H::TransferFunction,
            nb::Int64,nc::Int64,nd::Int64,nf::Int64,nk::Int64,method::ASCIIString,V::Float64=0.,N::Int64=0)
      # Check for stability
      if !isstable(G)
        warn("Identified model G is unstable")
      end
      if !isstable(H)
        warn("Identified model H is unstable")
      end

      # Everything is ok, create Object
      new(G,H,nb,nc,nd,nf,nk,method,V,N)
    end
end


#####################################################################
#=                     IDSpectralModel
            Model from Fourier or Spectral Analysis

                Implementation according to

              "Modeling of Dynamical Systems"

                    by Ljung and Glad

G           : Complex transfer function
f           : frequency vector that belongs to G
method      : Used method for identification

Author : Lars Lindemann @2015

                                                                   =#
#####################################################################
type idSpectralModel
    G::Array{Complex{Float64}}
    f::Array{Float64}
    method::ASCIIString

    function idSpectralModel(G::Array{Complex{Float64}},f::Array{Float64},method::ASCIIString)
      # Everything is ok, create Object
      new(G,f,method)
    end
end
