#####################################################################
#=                     IDDATA
            Datatype for System Identification

N    :   number of samples
nu   :   number of input channel
ny   :   number of output channel
Ts   :   Sampling time
y    :   N by ny matrix
u    :   N by nu matrix

Author : Lars Lindemann @2015

                                                                   =#
#####################################################################

type iddataObject
    y::Array
    u::Array
    Ts::Real
    N::Int
    nu::Int
    ny::Int
    inputnames::Vector{UTF8String}
    outputnames::Vector{UTF8String}

    function iddataObject(y::Array, u::Array, Ts::Real, outputnames, inputnames)
        N   = size(y, 1);
        ny  = size(y, 2);
        nu  = size(u, 2);

        # Validating amount of samples
        if size(y, 1) != size(u, 1)
            error("Input and output need to have the same amount of samples")
        end

        # Validate names of state, input, and output
        if length(inputnames)!=nu
            error("Inputnames need to match the number of channel inputs")
        elseif length(outputnames)!=ny
            error("Outputnames need to match the number of channel outputs")
        end

        # Validate sampling time
        if Ts <= 0
            error("Ts must be a real, positive number")
        end
        new(y, u, Ts, N, nu, ny, inputnames, outputnames)
    end
end

#####################################################################
##                      Constructor Functions                      ##
#####################################################################
@doc """`iddata = iddata(y, u, Ts, outputnames="", inputnames="")`

Creates an iddataObject that can be used for System Identification. y and u should have the data arranged in rows,
while the channels are sorted in columns.
Use for example sysIdentData = iddata(y1,[u1 u2],Ts,"Out",["In1" "In2"])""" ->
function iddata(y::Array, u::Array, Ts::Real, outputnames::Array{ASCIIString,1}="",inputnames::Array{ASCIIString,1}="")
    return iddataObject(y, u, Ts, outputnames, inputnames)
end

iddata(y::Array, u::Array, Ts::Real, outputnames::ASCIIString, inputnames::Array{ASCIIString,1}) = iddata(y, u, Ts, [outputnames], inputnames)
iddata(y::Array, u::Array, Ts::Real, outputnames::Array{ASCIIString,1}, inputnames::ASCIIString) = iddata(y, u, Ts, outputnames, [inputnames])
iddata(y::Array, u::Array, Ts::Real, outputnames::ASCIIString, inputnames::ASCIIString) = iddata(y, u, Ts, [outputnames], [inputnames])
