#!/usr/bin/python
import pylab as pb
pb.ion()
import sys
import numpy as np
import matplotlib.pyplot as plt
from sys import platform as _platform
from copy import copy, deepcopy

im = pb.imread('stella.jpg')
N = 15
im2 = deepcopy(im)

im2[:,:,0] = np.floor((im[:,:,0]+im[:,:,1]+im[:,:,2])/3)
im2[:,:,1] = im2[:,:,0]
im2[:,:,2] = im2[:,:,0]
pb.imsave('stella_intensity.png',im2);

im2[:,:,0] = im[:,:,1]
im2[:,:,1] = im[:,:,2]
im2[:,:,2] = im[:,:,0]
pb.imsave('stella_col1.png',im2);

im2[:,:,0] = im[:,:,2]
im2[:,:,1] = im[:,:,1]
im2[:,:,2] = im[:,:,0]
pb.imsave('stella_col2.png',im2);

im2[:,:,0] = im[:,:,2]
im2[:,:,1] = im[:,:,0]
im2[:,:,2] = im[:,:,1]
pb.imsave('stella_col3.png',im2);


sys.exit(0);


# Another example of a different transformation where we take the mean colour in a grid, didn't look that good on the board though.
dx = int(np.floor(im.shape[0]/N))
dy = int(np.floor(im.shape[1]/N))

for i in range(0,N):
    for j in range(0,N):
        x = im[i*dx:(i+1)*dx:1,j*dy:(j+1)*dy:1,:]
        col = [np.mean(x[:,:,0]), np.mean(x[:,:,1]), np.mean(x[:,:,2])]
        im2[i*dx:(i+1)*dx:1,j*dy:(j+1)*dy:1,:] = col
pb.imsave('stella_grid.png',im2)

im3 = deepcopy(im)
for i in range(0,N):
    for j in range(0,N):
        x = im[i*dx:(i+1)*dx:1,j*dy:(j+1)*dy:1,:]
        x = x.reshape(dx*dy,3)
        np.random.shuffle(x[:,0].T)
        np.random.shuffle(x[:,1].T)
        np.random.shuffle(x[:,2].T)
        x = x.reshape(dx,dy,3)
        im3[i*dx:(i+1)*dx:1,j*dy:(j+1)*dy:1,:] = x
pb.imsave('stella_random.png',im3)
