#!/usr/bin/python
import pylab as pb
pb.ion()
import sys
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D
from scipy.stats import multivariate_normal
import seaborn as sns
from sys import platform as _platform

def plotNormal2D(mu,K,fid,OS):
    N = 1000000
    X = np.random.multivariate_normal(mu,K,N)

    if OS=='linux':
        pb.figure(fid)
        sns.jointplot(X[:,0],X[:,1],kind='hex')
    else:
        nbins = 200
        H, xedges, yedges = np.histogram2d(X[:,0],X[:,1],bins=nbins)
        H = np.rot90(H)
        H = np.flipud(H)
    
        Hmasked = np.ma.masked_where(H==0,H)
        fig = plt.figure(fid)
        plt.pcolormesh(xedges,yedges,Hmasked)
        pb.ylim([-10,10])
        pb.xlim([-10,10])
        pb.axis([-10,10,-10,10])

def plotNormal1D(mu,sigma,fid,colour):
    N = 1000;

    pb.figure(fid)

    # generate some data
    x = mu+sigma*np.random.randn(N)
    # generate histogram
    n, bins, patches = pb.hist(x,50,normed=1,histtype='stepfilled')
    pb.setp(patches, 'facecolor',colour,'alpha',0.35)
    y = pb.normpdf(bins,mu,sigma)
    l = pb.plot(bins,y,'k--',linewidth=1.5)

if _platform == 'linux':
    OS = 'linux'
elif _platform == 'darwin':
    OS = 'OSX'
    print "You are running OS X sadly this means the plots will be a bit dull"
elif _platform == 'win32':
    OS = 'win'
    print "I'm sorry!"

plotNormal1D(0,10,0,'r')

plotNormal1D(0,10,1,'r')
plotNormal1D(0,3,1,'g')

plotNormal1D(0,10,2,'r')
plotNormal1D(0,3,2,'g')
plotNormal1D(-10,8,2,'b')

# visualise samples from 2D Gaussian
K = [[1,0],[0,1]]
mu = [0, 0]
plotNormal2D(mu,K,3,OS)

K = [[5,0],[0,1]]
mu = [0, 0]
plotNormal2D(mu,K,4,OS)

K = [[1,0.5],[0.5,1]]
mu = [0, 0]
plotNormal2D(mu,K,5,OS)

K = [[1,-0.5],[-0.5,1]]
mu = [0, 0]
plotNormal2D(mu,K,6,OS)

