/**
 * En rekursiv medåknings-parser för aritmetiska uttryck.
 * Se README för mer info.
 *
 * Författare: Per Austrin
 */
public class Parser {
	private Lexer lexer;

	public Parser(Lexer lexer) {
		this.lexer = lexer;
	}

	public ParseTree parse() throws SyntaxError {
		// Startsymbol är Expr
		ParseTree result = Expr();
		// Borde inte finnas något kvar av indata när vi parsat ett uttryck
		if (lexer.nextToken().getType() != TokenType.EOF) {
			throw new SyntaxError();
		}
		return result;
	}

	private ParseTree Expr() throws SyntaxError {
		ParseTree result = Term();
		while (lexer.peekToken().getType() == TokenType.PLUS ||
			   lexer.peekToken().getType() == TokenType.MINUS) {
			Token operator = lexer.nextToken();
			ParseTree next = Term();
			result = new BinaryOperation(operator.getType(), result, next);
		}
		return result;
	}
	
	private ParseTree Term() throws SyntaxError  {
		ParseTree result = Factor();
		while (lexer.peekToken().getType() == TokenType.TIMES ||
			   lexer.peekToken().getType() == TokenType.DIVIDE) {
			Token operator = lexer.nextToken();
			ParseTree next = Factor();
			result = new BinaryOperation(operator.getType(), result, next);
		}
		return result;
	}

	private ParseTree Factor() throws SyntaxError {
		Token t = lexer.nextToken();
		if (t.getType() == TokenType.NUM) return new NumberNode((Integer)t.getData());
		else if (t.getType() == TokenType.LPAREN) {
			ParseTree result = Expr();
			if (lexer.nextToken().getType() != TokenType.RPAREN)
				throw new SyntaxError();
			return result;
		}
		throw new SyntaxError();
	}

}
