function varargout = normdemo(varargin)
% NORMDEMO MATLAB code for normdemo.fig
%      NORMDEMO, by itself, creates a new NORMDEMO or raises the existing
%      singleton*.
%
%      H = NORMDEMO returns the handle to a new NORMDEMO or the handle to
%      the existing singleton*.
%
%      NORMDEMO('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in NORMDEMO.M with the given input arguments.
%
%      NORMDEMO('Property','Value',...) creates a new NORMDEMO or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before normdemo_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to normdemo_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help normdemo

% Last Modified by GUIDE v2.5 26-Apr-2016 21:05:30

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @normdemo_OpeningFcn, ...
                   'gui_OutputFcn',  @normdemo_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before normdemo is made visible.
function normdemo_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to normdemo (see VARARGIN)

% Choose default command line output for normdemo
handles.output = hObject;
p=2;
set(handles.normslider,'Value',p);
set(handles.normedit,'String',num2str(p));
draw_ball(handles)
figsize=get(handles.figure1,'position');
axessize=min(figsize(3)-100,figsize(4)-160);
set(handles.ballaxes,'Position',[50,100,axessize,axessize]);
set(handles.title,'Position',[50,figsize(4)-60,figsize(3)-50,50]);

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes normdemo wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = normdemo_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function normedit_Callback(hObject, eventdata, handles)
% hObject    handle to normedit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of normedit as text
%        str2double(get(hObject,'String')) returns contents of normedit as a double
p=str2num(get(hObject,'string'));
set(handles.normslider,'Value',p);
draw_ball(handles)

% --- Executes during object creation, after setting all properties.
function normedit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to normedit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on slider movement.
function normslider_Callback(hObject, eventdata, handles)
% hObject    handle to normslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
p=get(hObject,'Value');
set(handles.normedit,'String',num2str(p));
draw_ball(handles)


% --- Executes during object creation, after setting all properties.
function normslider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to normslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes when figure1 is resized.
function figure1_ResizeFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if isempty(handles) 
    % In startup phase, do nothing
else
    figsize=get(handles.figure1,'position');
    axessize=min(figsize(3)-100,figsize(4)-160);
    set(handles.ballaxes,'Position',[50,100,axessize,axessize]);
    titleheight=min(50,figsize(4)-100-axessize-10);
    set(handles.title,'Position',[50,figsize(4)-titleheight-10,...
                        figsize(3)-50,titleheight]);
end

function draw_ball(handles)
p=get(handles.normslider,'Value');
alpha=linspace(0,2*pi,101);
x=cos(alpha);
y=sin(alpha);
r=(abs(x).^p+abs(y).^p).^(1/p);
axes(handles.ballaxes);
plot(x./r,y./r)
if p<1
  set(handles.title,'String','Unit ball, for different p-"norms"')
else
  set(handles.title,'String','Unit ball, for different p-norms')
end
