
(** A simple implementation of a generic stack *)  

type 'a t
(** Abstract type of the stack *)

val create : unit -> 'a t
(** [create ()] returns a new empty stack. *)

val push : 'a -> 'a t -> 'a t
(** [push e s] pushes an element [e] to the top of stack [s] and
    returns the new stack *)

val pop : 'a t -> 'a t
(** [pop s] removes the top element from stack [s] and returns the new
    stack. If stack [s] is empty, an empty stack is returned. *)

val top : 'a t -> 'a option
(** [top s] return the top element of stack [s] as [Some e]. If 
    stack [s] is empty, [None] is returned. *)

val empty : 'a t -> bool
(** [empty s] returns true if stack [s] is empty, else false. *)

