open Printf
open Utils

type expr =
  | Float of float
  | Add of expr * expr
  | Mul of expr * expr
  | Pow2 of expr

let rec pprint e =
  match e with
    | Float(v) -> sprintf "%2.2f" v
    | Add(e1,e2) -> pprint e1 ^ "+" ^ pprint e2
    | Mul(e1,e2) -> pprint e1 ^ "*" ^ pprint e2
    | Pow2(e) -> pprint e ^ "^2"

let rec elimpow e =
  match e with 
    | Float(v) -> Float(v)
    | Add(e1,e2) -> Add(elimpow e1,elimpow e2)
    | Mul(e1,e2) -> Mul(elimpow e1,elimpow e2)
    | Pow2(e) -> Mul(elimpow e,elimpow e)

let rec eval e =
  match e with
    | Float(v) -> v
    | Add(e1,e2) -> eval e1 +. eval e2
    | Mul(e1,e2) -> eval e1 *. eval e2
   
let main =
  let e = Mul(Add(Float(12.),Float(7.4)),Pow2(Float(5.))) in
  e |> pprint |> print_endline;
  e |> elimpow |> eval |> printf "%2.2f\n"
