

open Utils
open Printf

type person = {name:string; age:int}
module OrderedPerson =
  struct 
    type t = person
    let compare x y = compare x.name y.name
  end

module PersonSet = Set.Make(OrderedPerson)

let main = 
  PersonSet.singleton {name="John"; age=33} 
    |> PersonSet.add {name="Anna"; age=57}
    |> PersonSet.add {name="John"; age=10}  
    |> PersonSet.iter 
	(fun p -> printf "name=%s, age=%d\n" p.name p.age)
  
