<?php

namespace Chat;

use Id1354fw\View\AbstractRequestHandler;
use Chat\Util\Constants;
use Chat\Model\Entry;

/**
 * Shows the chat conversation, allows the user to add and delete entries.
 *
 * @author Leif Lindback, leifl@kth.se
 */
class StoreEntry extends AbstractRequestHandler {

    private $msg;

    public function setMsg($msg) {
        $this->msg = $msg;
    }

    protected function doExecute() {
        $contr = $this->session->get(Constants::CHAT_CONTR_KEY);

        $contr->addEntry(new Entry($contr->getUsername(), $this->msg));
        $this->addVariable(Constants::CHAT_ENTRIES_VAR, $contr->getConversation(TRUE));
        $this->addVariable(Constants::CHAT_USERNAME_VAR, $contr->getUsername());

        $this->session->set(Constants::CHAT_CONTR_KEY, $contr);
        return Constants::CHAT_CONVERSATION_VIEW;
    }

}