
import cards.*;

public class EnumCardTest {

    public static void main(String[] args) {

        Card c1 = new Card(Rank.TWO, Suit.CLUBS);
        Card c2 = new Card(Rank.ACE, Suit.SPADES);

        System.out.println(c1.toString());
        System.out.println(c2.toString());
        
        // compare cards using ordinal()
        if(c2.getRankValue() > c1.getSuitValue()) {
            System.out.println(c2 + " has higher rank than " + c1);
        }
        else {
            System.out.println(c1 + " has higher rank than " + c2);
        }

        // create 13 cards, all of suit HEARTS
        Card[] theCards = new Card[13];
        int i = 0;
        for (Rank r : Rank.values()) {
            theCards[i] = new Card(r, Suit.HEARTS);
            i++;
         }
        
        System.out.println("The hearts: ");
        for(int j = 0; j < theCards.length; j++) {
            System.out.println(theCards[j]);
        }
    }
}
