close all; clear all; clc;

WorkDir=cd;

j=sqrt(-1); %Define the imaginary unit

%Add FEMM commands to Matlab path
addpath('C:\TPFAPPS\femm42\mfiles');

%Close the FEMM window (if opened)
closefemm;

%Open the FEMM window (in which the FEM computations are executed)
openfemm;

%Read machine parameters and mesh data
ProblemData;

%Define and draw the machine geometry and mesh in the FEMM window
Geometry;

mi_zoomnatural();

%Define the materials and label the different motor parts
Materials;

%Delete old problem (if existing)
delete('IndMachProb.fem');  %Problem formulation data stored in .fem-file
delete('IndMachProb.ans');  %Post-processor data stored in .ans-file

%Save the problem
mi_saveas('IndMachProb.fem')

%Create the mesh
mi_createmesh();

%Solve the problem
mi_analyze()

%Load and display the solution
mi_loadsolution();

cd(WorkDir);