%ProblemData.m
%%%%%%%%%%%%%%
%Input data used in the FEMM simulation 

%Pole number and geometrical data of the stator%%%%%%%%%%%%%%%%%%%%%%%%%%%%
p=2;                            %Number of poles [-]
Qs=6;                           %Number of stator slots [-]
ActiveL=0.2;                    %Active machine length [m]
ShaftRad=20e-3;                 %Shaft radius [m]
RotorRad=40e-3;                 %Rotor radius [m]
StatorRad=80.8e-3;              %Stator outer radius [m]
AirGapHeight=2e-3;              %Airgap height [m]
SlotPitch=2*pi/Qs;              %Stator slot pitch [rad]
PolePitch=2*pi/p;               %Pole pitch [rad]
InnerToothTipHeight=2e-3;       %Inner tooth tip height [m]
OuterToothTipHeight=6e-3;       %Outer tooth tip height [m]
StatorBackThickness=19.4e-3;    %Thickness of stator back [m]
ToothWidth=26e-3;               %Tooth width [m]
ToothOpeningWidth=8.7e-3;       %Tooth opening width [m]
ToothHeight=13.4e-3;            %Tooth height (straight part only) [m]

%Rotor data%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Qr=10;                          %Number of rotor slots [-]
RotorSlotPitch=2*pi/Qr;         %Rotor slot pitch [rad]
RotorSlotDepth=4e-3;            %Distance from outer rotor radius to widest part of rotor slot [m]
RotorSlotHeight=6.4e-3;         %Distance from widest part of rotor slot to bottom of rotor slot [m]
RotorSlotOpeningWidth=2.5e-3;   %Width of rotor slot opening [m]
InnerRotorSlotWidth=3.7e-3;     %Innermost width of a rotor slot [m]
OuterRotorSlotWidth=9e-3;       %Outer width of a rotor slot [m]
RotorBarConductivity=58;        %Rotor bar electrical conductivity [MS/m] (Copper=58 MS/m)
muRotorBar=1.0;                 %Relative permeability of the rotor bar material [-]

%Stator winding data%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
WireConductivity=58;            %Electrical conductivity [MS/m] (Copper=58 MS/m)
Turns=20;                       %Number of turns in one slot [-]        
WireDiam=1e-3;                  %Equivalent wire diameter of each turn [m]        
SlipFreq=0.5;                   %Slip frequency [Hz]
iPhase=2;                       %Peak phase current [A]

ia=iPhase;                      %a-phase phasor
ib=iPhase*(-1/2-j*sqrt(3)/2);   %b-phase phasor
ic=iPhase*(-1/2+j*sqrt(3)/2);   %c-phase phasor

%Material data%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
muWedge=1;      %Relative permeability of the (linear) stator slot wedge material [-]
muShaft=1000;   %Relative permeability of the (linear) shaft material [-]

%BH-curve for the stator lamination
BStatorLam=[0 0.5 1.0 1.5 2 2.5];
HStatorLam=[0 120 240 360 480 600];

%BH-curve for the rotor lamination 
BRotorLam=BStatorLam;
HRotorLam=HStatorLam;

%Mesh density variables%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
MeshStatorLam=0.1*(StatorRad-RotorRad-AirGapHeight); %Max length of mesh elements [m]
MeshSlot=MeshStatorLam; %Max length of mesh elements [m]
MeshAirGap=AirGapHeight; %Max length of mesh elements [m]
MeshWedge=MeshStatorLam; %Max length of mesh elements [m]
MeshRotor=MeshStatorLam; %Max length of mesh elements [m]
MeshShaft=MeshStatorLam; %Max length of mesh elements [m]
NoOfArcSegments=3; %Number of segments in one arc [-]