%MaterialsInsetPM.m
%%%%%%%%%%%
%Defines the laminations, shaft and slot materials (including current)

mu0=4*pi*10^(-7);   %Define mu0

%Define the materials%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Note that the stator slot material is added further below

%Define air as a material
mi_addmaterial('AirMat',1,1);  %Relative permeability=1 in both x- and y-directions (isotropic)

%Define the slot wedge material
mi_addmaterial('SlotWedgeMat',muWedge,muWedge);

%Define the shaft material
mi_addmaterial('ShaftMat',muShaft,muShaft);    

%Define the stator and rotor lamination materials
mu=4000;    %Relative magnetic permeability of the (linear) lamination [-]
%mi addmaterial(matname,mu x,mu y,Hc,J,Cduct,Lam_d,Phi_hmax,lam_fill,LamType,Phi_hx,Phi_hy,nstr,dwire)
mi_addmaterial('StatorLam',mu,mu,0,0,0,0.5,0,1,0,0,0,0,0);  %The BH-curve is modified below
mi_addmaterial('RotorLam',mu,mu,0,0,0,0.5,0,1,0,0,0,0,0);   %The BH-curve is modified below

%Define the BH-curve for the stator lamination
for i=1:length(BStatorLam)
    mi_addbhpoint('StatorLam',BStatorLam(i),HStatorLam(i));
end

%Define the BH-curve for the rotor lamination
for i=1:length(BRotorLam)
    mi_addbhpoint('RotorLam',BRotorLam(i),HRotorLam(i));
end

%Define the permanent-magnet material
mi_addmaterial('PermanentMagnet',muMagnet,muMagnet,HcMag,0,MagnetConductivity,ActiveL,0,1,0,0,0,0,0);

%Add the materials%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Add the shaft material
mi_clearselected();
mi_addblocklabel(0,ShaftRad/2);
mi_selectlabel(0,ShaftRad/2);
mi_setblockprop('ShaftMat',0,MeshShaft,'<None>',0,2,0);

%Add the rotor lamination material
mi_clearselected();
mi_addblocklabel(0,(RotorRad+ShaftRad)/2);
mi_selectlabel(0,(RotorRad+ShaftRad)/2);
mi_setblockprop('RotorLam',0,MeshRotor,'<None>',0,2,0);

%Add the air gap material
mi_clearselected();
mi_addblocklabel(0,RotorRad+MagnetHeight/2+AirGapHeight/2);
mi_selectlabel(0,RotorRad+MagnetHeight/2+AirGapHeight/2);
mi_setblockprop('AirMat',0,MeshAirGap,'<None>',0,2,0);

%Add the permanent-magnet material
for n=1:p
    mi_clearselected();
    mi_addblocklabel(-(RotorRad+MagnetHeight/2)*sin((n-1)*2*pi/p),(RotorRad+MagnetHeight/2)*cos((n-1)*2*pi/p));
    mi_selectlabel(-(RotorRad+MagnetHeight/2)*sin((n-1)*2*pi/p),(RotorRad+MagnetHeight/2)*cos((n-1)*2*pi/p));
    if rem(n,2)==0
        %South poles
        mi_setblockprop('PermanentMagnet',0,MeshAirGap,'<None>','theta+180',2,0);   
        %mi_setblockprop('AirMat',0,MeshAirGap,'<None>',0,2,0);
    else
        %North poles
        mi_setblockprop('PermanentMagnet',0,MeshAirGap,'<None>','theta',2,0);
        %mi_setblockprop('AirMat',0,MeshAirGap,'<None>',0,2,0);
    end
end

%Add the stator lamination materials
for n=1:1:Qs
    mi_clearselected();
    mi_addblocklabel((StatorRad-0.5*StatorBackThickness)*sin(-(n-1)*SlotPitch),(StatorRad-0.5*StatorBackThickness)*cos((n-1)*SlotPitch));
    mi_selectlabel((StatorRad-0.5*StatorBackThickness)*sin(-(n-1)*SlotPitch),(StatorRad-0.5*StatorBackThickness)*cos((n-1)*SlotPitch));
    mi_setblockprop('StatorLam',0,MeshStatorLam,'<None>',0,1,0);
    mi_clearselected();
end

%Add the slot wedge materials
R=RotorRad+AirGapHeight+0.5*InnerToothTipHeight;
for n=1:1:Qs
    mi_clearselected();
    mi_addblocklabel(R*sin(-(n-1)*SlotPitch),R*cos((n-1)*SlotPitch));
    mi_selectlabel(R*sin(-(n-1)*SlotPitch),R*cos((n-1)*SlotPitch));
    mi_setblockprop('SlotWedgeMat',0,MeshWedge,'<None>',0,1,0);
end

%Add phase A positive slot labels
mi_clearselected();
for n=1:1:Qs/(3*p)
    APos(n,:)=sprintf('A%d+',n);
end
%Add phase A negative slot labels
for n=1:1:Qs/(3*p)
    AMin(n,:)=sprintf('A%d-',n);
end
%Add phase B positive slot labels
for n=1:1:Qs/(3*p)
    BPos(n,:)=sprintf('B%d+',n);
end
%Add phase B negative slot labels
for n=1:1:Qs/(3*p)
    BMin(n,:)=sprintf('B%d-',n);
end
%Add phase B positive slot labels
for n=1:1:Qs/(3*p)
    CPos(n,:)=sprintf('C%d+',n);
end
%Add phase B negative slot labels
for n=1:1:Qs/(3*p)
    Cmin(n,:)=sprintf('C%d-',n);
end

SlotLabels=[];
for d=1:p/2
    SlotLabels=[SlotLabels; APos; Cmin; BPos; AMin; CPos; BMin];
end

%Define the stator slot materials
for n=1:length(SlotLabels(:,1))
    %mi_addmaterial(SlotLabels(n,:),1,1,0,0,WireConductivity,0,0,0,4,0,0,1,WireDiam*1e3);    %Note that the wire diameter should be in millimeters
    %%Test with slot wedge material also in the slots (to simulate a smooth air gap)
    mi_addmaterial(SlotLabels(n,:),muWedge,muWedge)    %Note that the wire diameter should be in millimeters
end

%Add the stator slot material
R=RotorRad+AirGapHeight+InnerToothTipHeight+0.5*(StatorRad-StatorBackThickness-RotorRad-AirGapHeight-InnerToothTipHeight);
q=Qs/3/p;
for n=1:1:Qs
    mi_clearselected();
    mi_addblocklabel(R*sin(-(n-1)*SlotPitch),R*cos((n-1)*SlotPitch));
    mi_selectlabel(R*sin(-(n-1)*SlotPitch),R*cos((n-1)*SlotPitch));
    if (SlotLabels(n,1)=='A' && SlotLabels(n,3)=='+')
        mi_setblockprop(SlotLabels(n,:),0,MeshSlot,'A',0,1,Turns);
    end
    if (SlotLabels(n,1)=='A' && SlotLabels(n,3)=='-')
        mi_setblockprop(SlotLabels(n,:),0,MeshSlot,'A',0,1,-Turns);
    end
    if (SlotLabels(n,1)=='B' && SlotLabels(n,3)=='+')
        mi_setblockprop(SlotLabels(n,:),0,MeshSlot,'B',0,1,Turns);
    end
    if (SlotLabels(n,1)=='B' && SlotLabels(n,3)=='-')
        mi_setblockprop(SlotLabels(n,:),0,MeshSlot,'B',0,1,-Turns);
    end
    if (SlotLabels(n,1)=='C' && SlotLabels(n,3)=='+')
        mi_setblockprop(SlotLabels(n,:),0,MeshSlot,'C',0,1,Turns);
    end
    if (SlotLabels(n,1)=='C' && SlotLabels(n,3)=='-')
        mi_setblockprop(SlotLabels(n,:),0,MeshSlot,'C',0,1,-Turns);
    end
end

%Rotate the rotor to the correct rotor position
mi_clearselected();
mi_seteditmode('group');
mi_selectgroup(2);
mi_moverotate(0,0,((Qs/(3*p)-1)*pi/Qs)*180/pi+180/p+RotorAngle*180/pi);
%mi_moverotate(0,0,0);

mi_clearselected();
mi_refreshview();
mi_zoomnatural();