close all; clear all; clc;

WorkDir=cd;

j=sqrt(-1); %Define the imaginary unit

%Add FEMM commands to Matlab path
addpath('C:\TPFAPPS\femm42\mfiles');

%Set the (stator) current
id=0; %d-axis current [A]
iq=5; %q-axis current [A]

%Close the FEMM window (if opened)
closefemm;

%Open the FEMM window (in which the FEM computations are executed)
openfemm;

%Read stator data (and set the rotor angle)
StatorData;

%Read rotor data
RotorDataInsetPM;

%Read mesh data
MeshData;

%Draw the stator geometry in the FEMM window
GeometryStator;

%Draw the rotor geometry in the FEMM window
GeometryRotorInsetPM;

mi_zoomnatural();

%Define the materials and label the different motor parts
MaterialsInsetPM;

cd('C:\EJ2210\Computer assignment')
%Delete old problem (if existing)
delete('PMMachProb.fem');  %Problem formulation data stored in .fem-file
delete('PMMachProb.ans');  %Post-processor data stored in .ans-file

%Save the problem
mi_saveas('C:\EJ2210\Computer assignment\PMMachProb.fem')

%Create the mesh
mi_createmesh();

%Solve the problem
mi_analyze()

%Load and display the solution
mi_loadsolution();

cd(WorkDir);

%Clear all selected contours (if any)
mo_clearcontour;

CircPropA=mo_getcircuitproperties('A');
CircPropB=mo_getcircuitproperties('B');
CircPropC=mo_getcircuitproperties('C');
CurrPhaseA=CircPropA(1); VoltPhaseA=CircPropA(2); PsiA=-CircPropA(3);
CurrPhaseB=CircPropB(1); VoltPhaseB=CircPropB(2); PsiB=-CircPropB(3);
CurrPhaseC=CircPropC(1); VoltPhaseC=CircPropC(2); PsiC=-CircPropC(3);

Psid=(2/3)*(cos(RotorAngle*p/2)*PsiA+cos(RotorAngle*p/2-2*pi/3)*PsiB+cos(RotorAngle*p/2+2*pi/3)*PsiC);
Psiq=(2/3)*(-sin(RotorAngle*p/2)*PsiA-sin(RotorAngle*p/2-2*pi/3)*PsiB-sin(RotorAngle*p/2+2*pi/3)*PsiC);
iaVect=CurrPhaseA;
ibVect=CurrPhaseB;
icVect=CurrPhaseC;