%StatorData.m
%%%%%%%%%%%%%%
%Input data for the stator used in the FEMM simulation

%Pole number and geometrical data of the stator%%%%%%%%%%%%%%%%%%%%%%%%%%%%
p=8;                            %Number of poles [-]
Qs=1*p*3;                       %Number of stator slots [-]
ActiveL=0.1;                    %Active machine length (stacking factor included) [m]
StatorRad=80.8e-3;              %Stator outer radius [m]
InnerToothTipHeight=1e-3;       %Inner tooth tip height (closest to slot opening) [m]
OuterToothTipHeight=2e-3;       %Outer tooth tip height [m]
StatorBackThickness=19.35e-3;   %Thickness of stator back [m]
ToothWidth=4.4e-3;              %Tooth width [m]
ToothOpeningWidth=1e-3;         %Tooth opening width [m]
ToothHeight=14.6e-3;            %Tooth height (straight part only) [m]

%Stator winding data%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Turns=50;                           %Number of turns in one slot [-]
WireDiam=1e-3;                      %Equivalent wire diameter of each turn [m]

RotorAngle=0.5; %Rotor angle [rad] (=0 => Rotor is magnetically aligned with the field corresponding to positive current in phase a)

%Material data%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
WireConductivity=58;            %Electrical conductivity [MS/m] (Copper=58 MS/m)
muWedge=1;                      %Relative permeability of the (linear) stator slot wedge material [-]
muLamination=10000;             %Relative permeability of the (linear) iron lamination material [-]

mu0=4*pi*10^(-7);               %Define mu0

%BH-curve for the stator lamination
HStatorLam=[0 120 240 360 480 600];
BStatorLam=mu0*muLamination.*HStatorLam;

%Compute the resulting slot and pole pitches
SlotPitch=2*pi/Qs;              %Stator slot pitch [rad]
PolePitch=2*pi/p;               %Pole pitch [rad]

%Compute the resulting phase currents
ia=id*cos(RotorAngle*p/2)-iq*sin(RotorAngle*p/2);                                  %Current in phase a [A]
ib=0.5*((-id+sqrt(3)*iq)*cos(RotorAngle*p/2)-(-sqrt(3)*id-iq)*sin(RotorAngle*p/2));  %Current in phase b [A]
ic=0.5*((-id-sqrt(3)*iq)*cos(RotorAngle*p/2)+(-sqrt(3)*id+iq)*sin(RotorAngle*p/2));  %Current in phase c [A]

ia=-ia; ib=-ib; ic=-ic; %Change sign of currents to correspond with used sign convention