%GeometryRotorInsetPM.m
%%%%%%%%%%%
%Draw the geometry for an inset PM rotor
 
%Create the shaft nodes and corresponding arc
mi_clearselected();
PxShaft=ShaftRad*sin(PolePitch/2);
PyShaft=ShaftRad*cos(PolePitch/2);
mi_addnode(PxShaft,PyShaft); 
mi_addnode(-PxShaft,PyShaft); 
mi_addarc(PxShaft,PyShaft,-PxShaft,PyShaft,PolePitch*180/pi,NoOfArcSegments); 

% %Create the nodes corresponding to the outer radius of the rotor lamination (and draw the corresponding arc)
% PxRotorRad=RotorRad*sin(PolePitch/2);
% PyRotorRad=RotorRad*cos(PolePitch/2);
% mi_addnode(PxRotorRad,PyRotorRad); 
% mi_addnode(-PxRotorRad,PyRotorRad); 
% mi_addarc(PxRotorRad,PyRotorRad,-PxRotorRad,PyRotorRad,PolePitch*180/pi,NoOfArcSegments);

%Create the nodes corresponding to the outer arc of the rotor magnet (and draw the corresponding arc)
mi_clearselected();
PxRotorMagnetOuterRad=(RotorRad+MagnetHeight)*sin(MagnetArcAngle/2);
PyRotorMagnetOuterRad=(RotorRad+MagnetHeight)*cos(MagnetArcAngle/2);
mi_addnode(PxRotorMagnetOuterRad,PyRotorMagnetOuterRad); 
mi_addnode(-PxRotorMagnetOuterRad,PyRotorMagnetOuterRad); 
mi_addarc(PxRotorMagnetOuterRad,PyRotorMagnetOuterRad,-PxRotorMagnetOuterRad,PyRotorMagnetOuterRad,MagnetArcAngle*180/pi,NoOfArcSegments);

%Create the nodes corresponding to the inner arc of the rotor magnet (and draw the corresponding arc)
mi_clearselected();
PxRotorMagnetInnerRad=RotorRad*sin(MagnetArcAngle/2);
PyRotorMagnetInnerRad=RotorRad*cos(MagnetArcAngle/2);
mi_addnode(PxRotorMagnetInnerRad,PyRotorMagnetInnerRad); 
mi_addnode(-PxRotorMagnetInnerRad,PyRotorMagnetInnerRad); 
mi_addarc(PxRotorMagnetInnerRad,PyRotorMagnetInnerRad,-PxRotorMagnetInnerRad,PyRotorMagnetInnerRad,MagnetArcAngle*180/pi,NoOfArcSegments);

%Create the lines corresponding to the sides of the rotor magnet
mi_addsegment(PxRotorMagnetInnerRad,PyRotorMagnetInnerRad,PxRotorMagnetOuterRad,PyRotorMagnetOuterRad);
mi_addsegment(-PxRotorMagnetInnerRad,PyRotorMagnetInnerRad,-PxRotorMagnetOuterRad,PyRotorMagnetOuterRad);

%Create the nodes corresponding to the outermost part of the rotor lamination (and draw the corresponding arcs and lines)
mi_clearselected();
PxRotorLaminationOuterRad1=(RotorRad+MagnetHeight)*sin(PolePitch/2);
PyRotorLaminationOuterRad1=(RotorRad+MagnetHeight)*cos(PolePitch/2);
PxRotorLaminationOuterRad2=(RotorRad+MagnetHeight)*sin(MagnetArcAngle/2+MagnetLeakageFluxBarrierAngle);
PyRotorLaminationOuterRad2=(RotorRad+MagnetHeight)*cos(MagnetArcAngle/2+MagnetLeakageFluxBarrierAngle);
mi_addnode(PxRotorLaminationOuterRad1,PyRotorLaminationOuterRad1); 
mi_addnode(PxRotorLaminationOuterRad2,PyRotorLaminationOuterRad2); 
mi_addarc(PxRotorLaminationOuterRad1,PyRotorLaminationOuterRad1,PxRotorLaminationOuterRad2,PyRotorLaminationOuterRad2,(PolePitch/2-MagnetArcAngle/2-MagnetLeakageFluxBarrierAngle/2)*180/pi,NoOfArcSegments);
mi_clearselected();
mi_addnode(-PxRotorLaminationOuterRad1,PyRotorLaminationOuterRad1); 
mi_addnode(-PxRotorLaminationOuterRad2,PyRotorLaminationOuterRad2); 
mi_addarc(-PxRotorLaminationOuterRad2,PyRotorLaminationOuterRad2,-PxRotorLaminationOuterRad1,PyRotorLaminationOuterRad1,(PolePitch/2-MagnetArcAngle/2-MagnetLeakageFluxBarrierAngle/2)*180/pi,NoOfArcSegments);
mi_clearselected();
PxRotorLaminationInnerRad=RotorRad*sin(MagnetArcAngle/2+MagnetLeakageFluxBarrierAngle);
PyRotorLaminationInnerRad=RotorRad*cos(MagnetArcAngle/2+MagnetLeakageFluxBarrierAngle);
mi_addnode(PxRotorLaminationInnerRad,PyRotorLaminationInnerRad); 
mi_addnode(-PxRotorLaminationInnerRad,PyRotorLaminationInnerRad); 
mi_addarc(PxRotorMagnetInnerRad,PyRotorMagnetInnerRad,PxRotorLaminationInnerRad,PyRotorLaminationInnerRad,MagnetLeakageFluxBarrierAngle*180/pi,NoOfArcSegments);
mi_addarc(-PxRotorMagnetInnerRad,PyRotorMagnetInnerRad,-PxRotorLaminationInnerRad,PyRotorLaminationInnerRad,MagnetLeakageFluxBarrierAngle*180/pi,NoOfArcSegments);
mi_clearselected();
mi_addsegment(PxRotorLaminationInnerRad,PyRotorLaminationInnerRad,PxRotorLaminationOuterRad2,PyRotorLaminationOuterRad2);
mi_addsegment(-PxRotorLaminationInnerRad,PyRotorLaminationInnerRad,-PxRotorLaminationOuterRad2,PyRotorLaminationOuterRad2);

%Set properties for the arc corresponding to the shaft
mi_clearselected();
mi_selectarcsegment(0,ShaftRad);
mi_setarcsegmentprop((MeshShaft/ShaftRad)*180/pi,'UnSpec',0,2);   %UnSpec is a not defined boundary

%Set properties for the arc corresponding to the inner arc of the rotor magnet
mi_clearselected();
mi_selectarcsegment(0,RotorRad);
mi_setarcsegmentprop((MeshRotor/RotorRad)*180/pi,'UnSpec',0,2);   %UnSpec is a not defined boundary

%Set properties for the arc corresponding to the outer arc of the rotor magnet
mi_clearselected();
mi_selectarcsegment(0,RotorRad+MagnetHeight);
mi_setarcsegmentprop((MeshAirGap/(RotorRad+MagnetHeight))*180/pi,'UnSpec',0,2);   %UnSpec is a not defined boundary

%Set properties for the lines corresponding to the sides of the rotor magnet
mi_clearselected();
mi_selectsegment(PxRotorMagnetInnerRad/2+PxRotorMagnetOuterRad/2,PyRotorMagnetInnerRad/2+PyRotorMagnetOuterRad/2);
mi_setsegmentprop('UnSpec',MeshAirGap,0,0,2);    %UnSpec is a not defined boundary
mi_clearselected();
mi_selectsegment(-PxRotorMagnetInnerRad/2-PxRotorMagnetOuterRad/2,PyRotorMagnetInnerRad/2+PyRotorMagnetOuterRad/2);
mi_setsegmentprop('UnSpec',MeshAirGap,0,0,2);    %UnSpec is a not defined boundary

%Set the properties for the arc corresponding to the outermost radii of the rotor lamination
mi_clearselected();
mi_selectarcsegment((RotorRad+MagnetHeight)*sin(PolePitch/2-MagnetLeakageFluxBarrierAngle),(RotorRad+MagnetHeight)*cos(PolePitch/2-MagnetLeakageFluxBarrierAngle));
mi_setarcsegmentprop((MeshRotor/(RotorRad+MagnetHeight))*180/pi,'UnSpec',0,2);   %UnSpec is a not defined boundary
mi_clearselected();
mi_selectarcsegment(-(RotorRad+MagnetHeight)*sin(PolePitch/2-MagnetLeakageFluxBarrierAngle),(RotorRad+MagnetHeight)*cos(PolePitch/2-MagnetLeakageFluxBarrierAngle));
mi_setarcsegmentprop((MeshRotor/(RotorRad+MagnetHeight))*180/pi,'UnSpec',0,2);   %UnSpec is a not defined boundary

%Set the properties for the lines corresponding to the rotor laminations siding the rotor magnets
mi_clearselected();
mi_selectsegment((RotorRad+0.5*MagnetHeight)*sin(0.5*MagnetArcAngle+MagnetLeakageFluxBarrierAngle),(RotorRad+0.5*MagnetHeight)*cos(0.5*MagnetArcAngle+MagnetLeakageFluxBarrierAngle));
mi_setsegmentprop('UnSpec',MeshAirGap,0,0,2);    %UnSpec is a not defined boundary
mi_clearselected();
mi_selectsegment(-(RotorRad+0.5*MagnetHeight)*sin(0.5*MagnetArcAngle+MagnetLeakageFluxBarrierAngle),(RotorRad+0.5*MagnetHeight)*cos(0.5*MagnetArcAngle+MagnetLeakageFluxBarrierAngle));
mi_setsegmentprop('UnSpec',MeshAirGap,0,0,2);    %UnSpec is a not defined boundary

%Set the properties for the small arcs siding the rotor magnets
mi_clearselected();
mi_selectarcsegment(RotorRad*sin(0.5*MagnetArcAngle+0.5*MagnetLeakageFluxBarrierAngle),RotorRad*cos(0.5*MagnetArcAngle+0.5*MagnetLeakageFluxBarrierAngle));
mi_setarcsegmentprop((MeshRotor/RotorRad)*180/pi,'UnSpec',0,2);   %UnSpec is a not defined boundary
mi_clearselected();
mi_selectarcsegment(-RotorRad*sin(0.5*MagnetArcAngle+0.5*MagnetLeakageFluxBarrierAngle),RotorRad*cos(0.5*MagnetArcAngle+0.5*MagnetLeakageFluxBarrierAngle));
mi_setarcsegmentprop((MeshRotor/RotorRad)*180/pi,'UnSpec',0,2);   %UnSpec is a not defined boundary

%Rotational copy of the rotor
mi_clearselected();
mi_seteditmode('group');
mi_selectgroup(2);  %Select the rotor
mi_copyrotate(0,0,PolePitch*180/pi,p-1);
