%RotorDataInsetPM.m
%%%%%%%%%%%%%%
%Input data for the rotor (inset mounted magnets) used in the FEMM simulation 

%Rotor geomatrical data%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ShaftRad=12e-3;                             %Shaft radius [m]
RotorRad=35e-3;                             %Outer radius of rotor lamination [m]
MagnetHeight=9e-3;                          %Height of rotor magnets [m]
MagnetArcAngle=90*(2*pi/(180*p));           %Magnet arcangle [rad] 
MagnetLeakageFluxBarrierAngle=2*pi/180;     %Magnet leakage-flux barrier angle [rad]

%Material data%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
muShaft=1;                      %Relative permeability of the (linear) shaft material [-]
muMagnet=1.05;                  %Relative permeability of the (linear) permanent magnet [s]
HcMag=10e05;                    %Permanent-magnet coercitivity [A/m]     
MagnetConductivity=10000;       %Magnet electrical conductivity [MS/m] (not used in dc-problems)

%BH-curve for the rotor lamination 
BRotorLam=BStatorLam;
HRotorLam=HStatorLam;

%Compute the resulting air-gap height (distance between inner stator radius and outer radius of the rotor lamination)
AirGapHeight=StatorRad-StatorBackThickness-ToothHeight-InnerToothTipHeight-RotorRad;
