<?php

namespace DataSite\View;

use Id1354fw\View\AbstractRequestHandler;
use DataSite\Util\Constants;

/**
 * Stores data entered by user, and shows a view with all data entered in the 
 * current session.
 */
class ShowData extends AbstractRequestHandler {
    private $theData;
    
    /**
     * Stores the value of the http parameter named 'theData'.
     * 
     * @param string $theData The value that is stored.
     */
    public function setTheData($theData) {
        $this->theData = $theData;
    }
    
    protected function doExecute() {
        $contr = $this->session->get(Constants::CONTR_KEY_NAME);
        
        $contr->addData($this->theData);        
        $this->addVariable('allData', $contr->getAllData());
        
        $this->session->set(Constants::CONTR_KEY_NAME, $contr);
        return 'subfolder/view-data';
    }
}
