<?php

class SuperClass {

    public static function whoAreYouSelf() {
        self::me();
    }

    public static function whoAreYouStatic() {
        static::me();
    }

    protected static function me() {
        echo "I am SuperClass";
    }

}

class SubClass extends SuperClass {

    protected static function me() {
        echo "I am SubClass";
    }

}
?>

<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title></title>
    </head>
    <body>
        <h1>
            <?php
            echo 'self: ';
            SubClass::whoAreYouSelf();
            ?>            
        </h1>
        <hr/>
        <h1>
            <?php
            echo 'static: ';
            SubClass::whoAreYouStatic();
            ?>
        </h1>
    </body>
</html>
