
/**
 * Output text with PrintWriter + BufferedWriter + FileWriter.
 */
import java.io.*;
import java.util.Date;

public class PrintWriterTest {

    public static void main(String[] args) throws IOException {

        // args[0] - name of output file
        if (args.length != 1) {
            System.out.println("Usage: java PrintWriterTest filename");
            System.exit(0);
        }

        PrintWriter fout = null;
        FileWriter fw = null;

        try {
            fw = new FileWriter(args[0]);
            fout = new PrintWriter(new BufferedWriter(fw));

            String text = "This text should appear in the file.";
            Date date = new Date();

            // Writing to file...
            fout.println(text);
            fout.println("Today is " + date.toString());

            // Writing to console
            System.out.println("Done.");
        } finally {
            if (fout != null) {
                fout.close();
            }
        }
    }
}
