
import java.util.Scanner; 

public class ScannerTest {

    static String newline = System.getProperty("line.separator");

    public static void main(String[] args) {

        // A Scanner handling simple input
        // NB: Default Locale if not stated otherwise 
        // Swedish standard -> ",", US standard -> "."
        Scanner cin = new Scanner(System.in);
		// cin.useLocale(java.util.Locale.US); // US standard, decimal point

        System.out.print("An integer, please: ");
        if (cin.hasNextInt()) {
            int i = cin.nextInt();
            System.out.println("Echo: " + i);
        } else {
            System.out.println("Not an integer.");
            // Skip all tokens until next line separator
            cin.skip("[^" + newline + "]" + newline);
        }

        System.out.print("Two doubles, please: ");
        for (int i = 0; i < 2; i++) {
            double d = cin.nextDouble();
            System.out.println("Echo: " + d);
        }

        cin.skip(newline); // Skip newline
        System.out.print("A line of text, please: ");
        String line = cin.nextLine();
        System.out.println("Echo: " + line);

        System.out.println("Separated in tokens: ");
        Scanner tokenizer = new Scanner(line);
        while (tokenizer.hasNext()) {
            System.out.println(tokenizer.next());
        }
        
        cin.close();
    }
}
