
/**
 * Input from a text file using BufferedReader + FileReader.
 */
import java.io.*;
import java.util.*;

public class FileReaderTest {

    public static void main(String[] argv) throws IOException {
        String line, name;
        int age;
        StringTokenizer tokenizer;

        BufferedReader fin = null;

        try {
            fin = new BufferedReader(new FileReader("personinfo.txt"));

            line = fin.readLine(); 	// Read a line from the file...
            while (line != null) {	// ...while there's more to read.

                try {
                    tokenizer = new StringTokenizer(line);
                    name = tokenizer.nextToken();
                    age = Integer.parseInt(tokenizer.nextToken());
                    System.out.println(name + "\t" + age + " years");
                } catch (NumberFormatException ne) {
                    System.out.println("Input mismatch. Skipping this line.");
                }

                line = fin.readLine();  // Read another line	
            }
        } catch (FileNotFoundException fe) {
            System.out.println("Can not find the specified file.");
            throw fe; // "do not nail your corpse in the upright position"
        } finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            } catch (IOException ie) {
            }
        }
    }
}
