/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package normal_MVC_view;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import model.TempModel;

/**
 *
 * @author johnsonh
 */
public class MVC_TempView extends VBox {

  private final TempModel model;
  private TextLabel textLabel;
  private TempBar tempBar;

  public MVC_TempView(TempModel model) {
    this.model = model;
    MVC_TempController controller;
    controller = new MVC_TempController(model, this);
    initView(controller);
  }

  class TextLabel extends Label {

    public TextLabel() {
      this.setText(makeString());
    }

    public void update() {
      this.setText(makeString());
    }

    private String makeString() {
      return " Celcius degrees: " + model.getCelsius();
    }
  }

  class TempBar extends Pane {

    double w, h;
    Rectangle r1, r2;

    public TempBar(double width, int height) {
      this.w = width;
      this.h = height;

      r1 = new Rectangle(0, 0, width, height);
      r1.setFill(Color.WHITE);
      r2 = new Rectangle(0, 0, width / 2, height);
      r2.setFill(Color.RED);
      getChildren().addAll(r1, r2);
    }

    public void update() {
      int temp = model.getCelsius();
      r2.setWidth(w * temp / 100);
    }

  }

  private void initView(MVC_TempController controller) {
    this.setPadding(new Insets(20));
    this.setSpacing(10);

    Button upButton = new Button("Up");
    upButton.setOnAction(new EventHandler<ActionEvent>() {
      @Override
      public void handle(ActionEvent event) {
        controller.handleUpButton();
      }
    });

    Button downButton = new Button("Down");
    downButton.setOnAction(new EventHandler<ActionEvent>() {
      @Override
      public void handle(ActionEvent event) {
        controller.handleDownButton();
      }
    });

    HBox upDownBox = new HBox();
    upDownBox.getChildren().add(upButton);
    upDownBox.getChildren().add(downButton);

    textLabel = new TextLabel();

    tempBar = new TempBar(100, 40);

    this.getChildren().add(upDownBox);
    this.getChildren().add(textLabel);
    this.getChildren().add(tempBar);

  }

  public void updateFromModel() {
    textLabel.update();
    tempBar.update();
  }
}
