/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package app;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import model.TempModel;

/**
 * FXML Controller class
 *
 * @author johnsonh
 */
public class Fxml_Temp_viewController implements Initializable {

  private model.TempModel model;
  double w, h;
  Rectangle r1, r2;

  @FXML
  private Label textLabel;
  @FXML
  private Pane tempBar;

  /**
   * Initializes the controller class.
   */
  @Override
  public void initialize(URL url, ResourceBundle rb) {
    model = new TempModel(0, 100);
    initTempBar();
  }

  @FXML
  private void handleUpButton(ActionEvent event) {
    model.setCelsius(model.getCelsius() + 1);
    update();

  }

  @FXML
  private void handleDownButton(ActionEvent event) {
    model.setCelsius(model.getCelsius() - 1);
    update();

  }

  private void update() {
    int temp = model.getCelsius();
    r2.setWidth(w * temp / 100);
    textLabel.setText(" Celcius degrees: " + temp);

  }

  private void initTempBar() {
    w = 100;
    h = 40;
    r1 = new Rectangle(0, 0, w, h);
    r1.setFill(Color.WHITE);
    r2 = new Rectangle(0, 0, w / 2, h);
    r2.setFill(Color.RED);
    tempBar.getChildren().addAll(r1, r2);
  }

}
