package model;

import java.util.Observable;

/* The subject to observe.
 * Inherited methods from Observable:
 * addObserver(...)
 * setChanged(...)
 * notifyObservers(...)
 * ...
 */
public class TempModel extends Observable {

  private int celsius;
  private final int MIN, MAX;

  public TempModel(int MIN, int MAX) {
    this.MIN = MIN;
    this.MAX = MAX;
    celsius = (MIN + MAX) / 2;
  }

  public int getCelsius() {
    return celsius;
  }

  public void setCelsius(int cels) {
    if (cels < MIN) {
      celsius = MIN;
    } else if (cels > MAX) {
      celsius = MAX;
    } else {
      celsius = cels;
    }

    // The model has changed, notify observers!
    this.setChanged();
    this.notifyObservers();

  }
}
