/* This file contains the definition of the CodeWriter class */ 
#pragma once
#include <iostream>
#include <fstream>
#include <string>
#include "VMParser.h"

const char kPathSeparator =
#if defined _WIN64 || defined _WIN32
                            '\\';
#else
                            '/';
#endif

using namespace std;

class CodeWriter
{
protected:
	fstream outFile; /** the fstream object into which the ASM code is written */
	bool needHalt;   /** set to true if the infinite loop should be added at the end of the ASM code */
	unsigned int labelNumber;  /** counter used for creating a unique label */	
	string fileName; /** name of the VM file currently being compiled, not that of the ASM file */
	string functionName; /** name of the function currently being compiled, empty if not in a function */

	string makeUniqueLabel();
	string makeLocalLabel(string label);
	
public:
	CodeWriter(const char* output);
	~CodeWriter(void);

	void setFileName(const char* filename);	
	void writePushPop(CmdType cmd, string segment, int index); 
	void writeArithmetic(string command);
	void writeInit(bool sysinit);
	void writeLabel(string label);
	void writeGoto(string label);
	void writeIf(string label);
	void writeCall(string funcName, int numArgs);
	void writeReturn();
	void writeFunction(string funcName, int numLocals);
};

