import KinectPV2.KJoint;            
import KinectPV2.*;
import oscP5.*;
import netP5.*;
import signal.library.*;

OscP5 oscP5;
NetAddress myAddress;
KinectPV2 kinect;
SignalFilter myFilter;
SignalFilter myFilter2;
SignalFilter myFilter3;
SignalFilter myFilter4;

float freq      = 120.0;
float minCutoff = 0.01; // decrease this to get rid of slow speed jitter
float beta      = 9.0;  // increase this to get rid of high speed lag
float dcutoff   = 1.0;

float rightHandX, rightHandY, leftHandX, leftHandY;

float rightHandSize, leftHandSize, rightHandSizePrev, LeftHandSizePrev;
float totalRightHandSize, totalRightHandSizePrev;
float centerHandSize, centerHandSizePrev;

float magRight;
float magRightPrev;
float magRightCount;
float magnitudeRight;
float velAlter;

float velocityRight;
float velocityRightAvg;
float velocityRightAvgPrev;
float velocityRight2;
float velocityRightSum;
float velocityRightAvg2;
float velocityRightAvgPrev2;
float velocityRightTotal;
float velocityCenterHand;

float velocityRightMax;
float velocityRightMaxPrev;
float velocityRightSample;
float velocityRightSamplePrev;
float velRightLR;

float jerkinessRight, jerkinessRight2, jerkinessRightPrev, jerkinessRightPrev2;
float jerkinessIndex, jerkinessIndexPrev, jerkinessRightMax;
float jerkRight, jerkRightPrev, jerkRightMax, jerkRightMaxPrev;
float jerkRightPrev2, jerkRightPrev3, jerkRightPrev4;

float time1;
float time2;
float timeDiff;
float posMax;
float posMin;
float posDiff;
float posVel;

int start;
int stopCount;
int dir;
int sizeDir;
int sizeDirCount;
int velOutCount;
int velInCount;
int velTrig;
int jerkCount;
int jerkRightCnt;

PVector orgSignalLeft;
PVector orgSignalLeftPrev;

PVector orgSignalRight;
PVector orgSignalRightPrev;
PVector orgSignalRightPrev2;
PVector orgSignalRightPrev3;
PVector orgSignalRightPrev4;
PVector orgSignalRightPrev5;

PVector filSignalLeft;
PVector filSignalLeftPrev;
PVector filSignalRight;
PVector filSignalRightPrev;
PVector filSignalRightPrev2;
PVector filSignalRightPrev3;
PVector filSignalRightPrev4;
PVector filSignalRightPrev5;
PVector filButtSignalRight;
PVector filButtSignalRightPrev;

PVector filSpineMid;
PVector filRightShoulder;
PVector filRightElbow;

PVector rightSpeedVector, rightSpeedVectorPrev, rightAccVector, rightAccVectorPrev, rightJerkVector, rightJerkVectorPrev, rightJerkVector2, rightJerkVectorPrev2; 
PVector rightJerkButtFilt, rightJerkButtFiltPrev;

PVector spineMid;
PVector spineMidPrev;
PVector spineMidX;
PVector spineMidY;
PVector spineMidVect;
PVector spineCenter;
PVector center;
PVector rightVelCenter;
PVector magRightVector;
PVector rightShoulder, rightElbow, rightHand;
PVector spineShoulder;
PVector centerShoulder;
PVector centerHand;
PVector centerHandPrev;
PVector centerHandVel;
PVector leftShoulder, leftElbow, leftHand;
PVector rightUpperArm, rightForeArm, spineShoulderVect;

int x = 0;

void setup() {                                                                // Setup global parameters and initialize variables declared above  
  //size(1920, 1080);
  //surface.setResizable(true);
  //background(255);
  frameRate(30);

  rightHandX = rightHandY = leftHandX = leftHandY = Float.MAX_VALUE;

  /* create an oscP5 instance using TCP. 
   * the remote address is 127.0.0.1 @ port 11000 = the server from above
   */

  oscP5 = new OscP5(this, 12000);
  myAddress = new NetAddress("127.0.0.1", 12001);
  
  myFilter = new SignalFilter(this, 3);
  myFilter2 = new SignalFilter(this, 3);
  myFilter3 = new SignalFilter(this, 3);
  myFilter4 = new SignalFilter(this, 3);

  orgSignalLeft = new PVector(Float.MAX_VALUE, Float.MAX_VALUE); 
  orgSignalRight = new PVector(Float.MAX_VALUE, Float.MAX_VALUE);
  orgSignalLeftPrev = new PVector(Float.MAX_VALUE, Float.MAX_VALUE);
  orgSignalRightPrev = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  orgSignalRightPrev2 =  new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  orgSignalRightPrev3 =  new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  orgSignalRightPrev4 =  new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  orgSignalRightPrev5 =  new PVector (Float.MAX_VALUE, Float.MAX_VALUE);

  filSignalLeft = new PVector(Float.MAX_VALUE, Float.MAX_VALUE); 

  filSignalRight = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  filSignalLeftPrev = new PVector(Float.MAX_VALUE, Float.MAX_VALUE);

  filSignalRightPrev = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  filSignalRightPrev2 = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  filSignalRightPrev3 = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  filSignalRightPrev4 = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  filSignalRightPrev5 = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  filButtSignalRight = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  filButtSignalRightPrev = new PVector (0.0, 0.0); 
  rightJerkButtFilt = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  rightJerkButtFiltPrev = new PVector (0.0, 0.0);

  filSpineMid = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  filRightShoulder = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  filRightElbow = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);

  spineMid = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  spineMidPrev = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  spineMidX = new PVector (Float.MAX_VALUE, Float.MAX_VALUE); 
  spineMidY = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  spineMidVect = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  spineCenter = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  rightVelCenter = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);

  center = new PVector(100.0, 0.0);
  magRightVector = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);

  rightShoulder = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  rightElbow = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  leftShoulder = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  leftElbow = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  rightUpperArm = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  rightForeArm = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  centerShoulder = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  centerHand = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  centerHandPrev = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  spineShoulder = new PVector (Float.MAX_VALUE, Float.MAX_VALUE);
  spineShoulderVect =  new PVector (Float.MAX_VALUE, Float.MAX_VALUE);

  rightSpeedVector = new PVector(Float.MAX_VALUE, Float.MAX_VALUE);
  rightSpeedVectorPrev = new PVector(Float.MAX_VALUE, Float.MAX_VALUE);
  centerHandVel = new PVector(Float.MAX_VALUE, Float.MAX_VALUE);
  rightAccVector = new PVector(Float.MAX_VALUE, Float.MAX_VALUE);
  rightAccVectorPrev = new PVector(Float.MAX_VALUE, Float.MAX_VALUE);
  rightJerkVector = new PVector(Float.MAX_VALUE, Float.MAX_VALUE);
  rightJerkVectorPrev = new PVector(Float.MAX_VALUE, Float.MAX_VALUE);
  rightJerkVector2 = new PVector(Float.MAX_VALUE, Float.MAX_VALUE);
  rightJerkVectorPrev2 = new PVector(Float.MAX_VALUE, Float.MAX_VALUE);

  magRight = 0.0;
  magRightPrev = 0.0;
  magnitudeRight = 0.0;
  magRightCount = 0;
  velAlter = 0.0;

  totalRightHandSize = 0.0;
  totalRightHandSizePrev = 0.0;
  centerHandSize = 0.0;
  centerHandSizePrev = 0.0;

  velocityRight = 0.0;
  velocityRightAvg = 0.0;
  velocityRightAvgPrev = 0.0;
  velocityRight2 = 0.0;
  velocityRightSum = 0.0;
  velocityRightAvg2 = 0.0;
  velocityRightAvgPrev2 = 0.0;
  velocityRightTotal = 0.0;
  velocityCenterHand = 0.0;

  velocityRightMax = 0.0;
  velocityRightMaxPrev = 0.0;
  velocityRightSample = 0.0;
  velocityRightSamplePrev = 0.0;
  jerkinessRight = 0.0;
  jerkinessRight2 = 0.0;
  jerkinessRightPrev = 0.0;
  jerkinessRightPrev2 = 0.0;
  jerkinessIndex = 0.0;
  jerkinessIndexPrev= 0.0;
  jerkinessRightMax = 0.0;
  jerkRight = 0.0;
  jerkRightPrev = 0.0;
  jerkRightPrev2 = 0.0;
  jerkRightPrev3 = 0.0;
  jerkRightPrev4 = 0.0;
  jerkRightMax = 0.0;
  jerkRightMaxPrev = 0.0;
  jerkRightCnt = 0;

  time1 = 0.0;
  time2 = 0.0;
  timeDiff = 0.0;
  posMax = 0.0;
  posMin = 0.0;
  posVel = 0.0;
  velRightLR = 0.0;

  rightHandSize = leftHandSize = 0;
  rightHandSizePrev = leftHandSize = 0;

  start = -1;
  stopCount = 0;
  dir = 0;
  sizeDir = 0;
  sizeDirCount = 0;
  
  velOutCount = 0;
  velInCount = 0;
  velTrig = 0;
  jerkCount = 0;

  kinect = new KinectPV2(this);

  kinect.enableSkeletonColorMap(true);
  kinect.enableColorImg(true);

  kinect.init();
}

void draw() {                                                                    // Function that is called every frame
  background(255);
  //translate(width/2, height/2);

  //image(kinect.getColorImage(), 0, 0, width, height);

  ArrayList<KSkeleton> skeletonArray =  kinect.getSkeletonColorMap();

  myFilter.setFrequency(freq);                                                   // Setting up 3 filters
  myFilter.setMinCutoff(minCutoff);
  myFilter.setBeta(beta);
  myFilter.setDerivateCutoff(dcutoff);

  myFilter2.setFrequency(freq);
  myFilter2.setMinCutoff(minCutoff);
  myFilter2.setBeta(beta);
  myFilter2.setDerivateCutoff(dcutoff);

  myFilter3.setFrequency(freq);
  myFilter3.setMinCutoff(minCutoff);
  myFilter3.setBeta(beta);
  myFilter3.setDerivateCutoff(dcutoff);


  //individual JOINTS  ----    skeleton data extraction 
  
  for (int i = 0; i < skeletonArray.size(); i++) {
    KSkeleton skeleton = (KSkeleton) skeletonArray.get(i);
    if (skeleton.isTracked()) {
      KJoint[] joints = skeleton.getJoints();

      color col  = skeleton.getIndexColor();
      fill(col);
      stroke(col);
      //drawBody(joints);

      rightShoulder.set(joints[KinectPV2.JointType_ShoulderRight].getX(), joints[KinectPV2.JointType_ShoulderRight].getY());       // Acquiring joint data from Kinect 
      rightElbow.set(joints[KinectPV2.JointType_ElbowRight].getX(), joints[KinectPV2.JointType_ElbowRight].getY());

      //spineShoulder.set(joints[KinectPV2.JointType_SpineShoulder].getX(), joints[KinectPV2.JointType_SpineShoulder].getY());

      orgSignalRight.set(joints[KinectPV2.JointType_HandRight].getX(), joints[KinectPV2.JointType_HandRight].getY());
      //orgSignalLeft.set(joints[KinectPV2.JointType_HandLeft].getX(), joints[KinectPV2.JointType_HandLeft].getY());

      spineMid.set(joints[KinectPV2.JointType_SpineMid].getX(), joints[KinectPV2.JointType_SpineMid].getY());

      //spineMidX.set(joints[KinectPV2.JointType_SpineMid].getX(), 0.0);
      //spineMidY.set(0.0, joints[KinectPV2.JointType_SpineMid].getY());

      //spineMidVect.set(spineMidX);
      //spineMidVect.sub(spineMidY);

      //spineCenter.set(spineMid);
      //spineCenter.sub(spineMidVect);

      //rightVelCenter.set(spineMid);
      
      
      if (frameCount == 60) {                                              // Send a start signal to Pure Data after frame count is more than 60 
        
        OscMessage startOn = new OscMessage("/start"); 
        startOn.add(start);
        oscP5.send(startOn, myAddress);
      }
     
      
      if ( (joints[KinectPV2.JointType_HandRight].getState() != KinectPV2.HandState_NotTracked) && (frameCount > 90) && (start == -1) ) {     // Global START --- right hand detection
  
          start = 1;
          
          println(frameCount);
          
          OscMessage startOn = new OscMessage("/start"); 
          startOn.add(start);
          oscP5.send(startOn, myAddress);
          
          stopCount = 0;
          
        } else if ((joints[KinectPV2.JointType_HandRight].getState() == KinectPV2.HandState_NotTracked)) {     // Global STOP if the hand is not detected for more than 30 frames

          stopCount += 1;
        
          if (stopCount > 30) {
            
            start = -1;

            OscMessage startOn = new OscMessage("/start"); 
            startOn.add(start);
            oscP5.send(startOn, myAddress);

            stopCount = 0;

            rightHandSizePrev = 0;
            totalRightHandSizePrev = 0;
          }
        } else {
          stopCount = 0;
        }


      if ( start == 1 ) {                                                           // Main hands detection condition  ****************************

        filSignalRight = myFilter.filterCoord2D(orgSignalRight, width, height);     // Filtering of Kinect joint data
        filSpineMid = myFilter2.filterCoord2D(spineMid, width, height);
        filRightShoulder = myFilter3.filterCoord2D(rightShoulder, width, height); 
        filRightElbow = myFilter4.filterCoord2D(rightElbow, width, height); 

        rightSpeedVector.set(filSignalRight);
        //rightVelCenter.sub(filSignalRight);

        if (frameCount > 5) {                                                        // In order to gather enough information (previous values) for all calculations we need at least 5 frames

          rightSpeedVector.sub(filSignalRightPrev);                                  // Right hand raw velocity calculation 

          filButtSignalRight = Butterworth(rightSpeedVector, rightSpeedVectorPrev, filButtSignalRightPrev);        // Filtering velocity with a Butterworth filter 
          //println("Velocity Butt: " + filButtSignalRight.mag());
          //println("Speed x: " + filButtSignalRight.x);
          //println("Speed y: " + filButtSignalRight.y);
          //println("Speed FiltPrev: " + filButtSignalRightPrev.mag());
          //println("-------------------------------------");

          //float velo = PVector.dist(filSignalRight, filSignalRightPrev);
          //println("Velocity velo: " + velo);
          //println("Velocity mag: " + rightSpeedVector.mag());

          rightAccVector.set(rightSpeedVector);                                     // Right hand acceleration calculation
          rightAccVector.sub(rightSpeedVectorPrev);

          rightJerkVector.set(rightAccVector);                                      // Right hand jerkiness calculation
          rightJerkVector.sub(rightAccVectorPrev);

          rightJerkVector2.x = jerkinessFunc2(filSignalRight.x, filSignalRightPrev.x, filSignalRightPrev2.x, filSignalRightPrev3.x);     // Alternative way of calculating jerkiness
          rightJerkVector2.y = jerkinessFunc2(filSignalRight.y, filSignalRightPrev.y, filSignalRightPrev2.y, filSignalRightPrev3.y);


          if (rightJerkVector2.mag() > 0 && rightJerkVectorPrev2.mag() > 0) {                                                            // Filtering of jerkiness with Butterworth filter
            rightJerkButtFilt = Butterworth(rightJerkVector2, rightJerkVectorPrev2, rightJerkButtFiltPrev);
          }

          //println("Jerk2 : " + rightJerkVector2.mag());
          //println("Jerk2 Prev: " + rightJerkVectorPrev2.mag());
          //println("Jerk2 Filt: " + rightJerkButtFilt.mag());
          //println("Jerk2 FiltPrev: " + rightJerkButtFiltPrev.mag());
          //println("-------------------------------------");

          //if (filButtSignalRight.mag() > 0.8) { 
          //float angleRad = PVector.angleBetween(center, filButtSignalRight);
          //float angleDeg = degrees(angleRad);

          //  OscMessage angl = new OscMessage("/angle"); 
          //  angl.add(angleDeg);
          //  oscP5.send(angl, myAddress);

          ////println("Angle: " + angleDeg);
          //}



          if (frameCount > 20) {

            OscMessage handMag = new OscMessage("/handMag");                                                  // Sending raw hand magnitude to PD calculated as a magnitude of a vector from (0,0) to right hand joint
            handMag.add(filSignalRight.mag());
            oscP5.send(handMag, myAddress);

            if ( (filButtSignalRight.mag() > 0) && (filButtSignalRight.mag() < 250) ) {                       // Sending VelRaw velocity values to PD 

              //float velButtRaw = filButtSignalRight.mag();

              OscMessage velButt = new OscMessage("/rightVelButt");                                            
              velButt.add(rightSpeedVector.mag());
              oscP5.send(velButt, myAddress);

              //println("Velocity raw: " + filButtSignalRight.mag());
            }
            
            jerkRight = rightJerkVector.mag();  
            
            OscMessage jerk = new OscMessage("/jerkinessRaw");                                                // Sending raw jerkines values to PD
            jerk.add(jerkRight);
            oscP5.send(jerk, myAddress);
            
            //float jerkRightFil1 = medianFilter (jerkRight, jerkRightPrev, jerkRightPrev2, jerkRightPrev3, jerkRightPrev4);
            //float jerkRightFil2 = movingAverage(jerkRight, jerkRightPrev, jerkRightPrev2, jerkRightPrev3, jerkRightPrev4); 

            OscMessage jerk2 = new OscMessage("/jerkinessRaw2");                                              // Sending raw jerkines values calculated in alternative way to PD
            jerk2.add(rightJerkVector2.mag());
            oscP5.send(jerk2, myAddress);

            //println("Jerkiness: " + rightJerkVector2.mag() );
          }
        }

        rightUpperArm.set(filRightShoulder);                                                    //
        rightUpperArm.sub(filRightElbow);                                                       //  
        rightForeArm.set(filRightElbow);                                                        //
        rightForeArm.sub(filSignalRight);                                                       //
        centerShoulder.set(filSpineMid);                                                        //    Setting up vectors needed for calculatio of calibration values
        centerShoulder.sub(filRightShoulder);                                                   //
        centerHand.set(filSpineMid);                                                            //
        centerHand.sub(filSignalRight);                                                         //

        rightHandSize = rightUpperArm.mag() + rightForeArm.mag();                               //    Calculation of right hand size

        totalRightHandSize = rightHandSize + centerShoulder.mag();                              //    Calculation of total right hand size (maximal possible value used in calibration)
        centerHandSize = centerHand.mag();                                                      //    Calculation of current distance between right hand joint and central spine joint - used for calculation of current dynamics (volume) 
        
        centerHandVel.set(centerHand);                                                          //
        centerHandVel.sub(centerHandPrev);                                                      //    Calculation of raw velocity of center - hand vector
        velocityCenterHand = centerHandVel.mag();                                               //
        
        OscMessage velCH = new OscMessage("/centerHandVel"); 
        velCH.add(velocityCenterHand);
        oscP5.send(velCH, myAddress);
   

        //println("Total right hand size: " + totalRightHandSize);
  
        magRightVector.set(filRightShoulder);                                                  //
        magRightVector.sub(filSignalRight);                                                    //    Calculating right hand size as the distance between 
                                                                                               //    right shoulder joint and right hand joint (Vol_2) 
        magRight = magRightVector.mag();                                                       //

        //println("Hand magnitude: " + magRight);

        if ( (rightHandSize > rightHandSizePrev) ) {                                           //    Calculation of maximum (reference) hand size (Vol_1 and Vol_2)
                                                                                               //    and sending it to PD        
          rightHandSizePrev = rightHandSize;  
          //println("Right Hand size: " + rightHandSize);

          OscMessage rightSize = new OscMessage("/rightHandSize"); 
          rightSize.add(rightHandSize - 10);
          oscP5.send(rightSize, myAddress);
        } 
        
        //println("Hand y position: " + filSignalRight.y);
        //println("Center y position: " + filSpineMid.y);
        //println("----------------------------------------");
        
        if ( (totalRightHandSize > totalRightHandSizePrev) && (filSignalRight.x > (filSpineMid.x + 50) ) && (sizeDir == 1) ) {      // Detection of TOTAL maximum (reference) hand size (Vol_3) and sending it to PD
     
            OscMessage totalRightSize = new OscMessage("/totalRightHandSize"); 
            totalRightSize.add(totalRightHandSize - 40);
            oscP5.send(totalRightSize, myAddress);
            
            totalRightHandSizePrev = totalRightHandSize; 
            
            //println("Total Right Hand size: " + totalRightHandSize);
       
        } 
        
        //println("Total Right Hand size: " + totalRightHandSizePrev);
        //println("--------------------------");

        if ( magRight > (magRightPrev + 2) ) {                                                 // Trying to detect current hand size (Vol_2) and sending to PD

          magRightCount += 1;
          
        } else if (magRightCount > 15) {

          OscMessage amountRight2 = new OscMessage("/amountRight2"); 
          amountRight2.add(magnitudeRight);
          oscP5.send(amountRight2, myAddress);

          //println("Max hand size: " + magRightPrev);
          //println("----------------------");
          magRightCount = 0;
        }
        
        
        
        if (filSignalRight.x > filSpineMid.x) {
          
          if (centerHandSize > centerHandSizePrev ) {                                           //  Detection of movement towards OUT (while looking at centerHandSize)
            
            sizeDirCount += 1;
            
            if (sizeDirCount > 10) {
            sizeDir = 1;
            }
            //println("Center Hand: " + centerHandSize);
            //println("Center Hand Prev: " + centerHandSizePrev);
            //println("------------------------------");
          } 
        
          
          if ((centerHandSize < (centerHandSizePrev - 1)) && (sizeDir == 1)) {                       //  Trying to detect current value of centerHand  (Vol_3)
            
            sizeDirCount = 0;
            sizeDir = 0;
     
            OscMessage CH = new OscMessage("/centerHand"); 
            CH.add(centerHandSizePrev);
            oscP5.send(CH, myAddress);
  
            //println("Current max center-hand size: " + centerHandSizePrev);
            //println("---------------------------------------------");
          }
          
          OscMessage cenHndDir = new OscMessage("/sizeDirCount"); 
          cenHndDir.add(sizeDir);
          oscP5.send(cenHndDir, myAddress);
  
          //println("Size direction: " + sizeDir);  
        }
        
        
        if ( jerkRight > jerkRightPrev ) {           // Detection of max jerkiness overall 
            
            jerkRightMax = jerkRight;  
            jerkRightCnt += 1;
    
        } else if (jerkRightCnt > 0 )  {
          
          jerkRightCnt = 0;
        }

        if ( (jerkRight < 0.3 * jerkRightMax) && (jerkRightCnt == 0) && (jerkRightMax >= 6 ) && (jerkRightMax <= 150 ) ) {
          
          //println("Right jerk max: " + jerkRightMax);
          //println("------------------------------------");
          if (jerkRightMax > 90) {
            
            OscMessage maxJerk1 = new OscMessage("/jerkMaxRaw"); 
            maxJerk1.add(jerkRightMax * 0.70);
            oscP5.send(maxJerk1, myAddress);
            
            println("Jerk max * 0.70: " + (jerkRightMax * 0.70));
            println("Jerk max: " + jerkRightMax);
            println("--------------------------------");
            
            jerkRightCnt = 0;
            jerkRightMax = 0;
          
          } else if (jerkRightMax > (jerkRightMaxPrev / 2) ) { 
          
            OscMessage maxJerk2 = new OscMessage("/jerkMaxRaw"); 
            maxJerk2.add(jerkRightMax);
            oscP5.send(maxJerk2, myAddress);
            
            println("Jerk min: " + jerkRightMax);
          
            jerkRightCnt = 0;
            jerkRightMax = 0;
          } 
        }  
        
        /*-------------------------------------------------------------------------------------------------------------------------------------------*/
        
        if ( (filSignalRight.x < (filSignalRightPrev.x - 0.4)) && (dir == 1) ) {                  //  Right maximum of movement 

          dir = 0;
          velTrig = 0;
          velocityRightSamplePrev = 0;
          velocityRightMax = 0.0;
          velocityRightMaxPrev = 0.0;
          jerkinessRightMax = 0;
          jerkCount = 0;

          //println("Time maximum: " + time1);
          //println("Direction right: " + dir);

          if (time1 == 0) {
            time1 = millis();
          } else {
            time1 = 0;
          }

          if ( (time2 != 0) && (time1 != 0) && (velOutCount > 6)) {                           //Calculating time difference in MAX position
            timeDiff = time1 - time2;

            //println("Time difference max: " + timeDiff);
            //println("VelOutCount: " + velOutCount);

            velRightLR = ( 1 / timeDiff ) * 1000;

            //println("Max pos vel: " + velRightLR);
            //println("Vel out count: " + velOutCount);
            //println("time1= "+ time1 + " time2= " + time2);

            OscMessage velMinMax = new OscMessage("/rightHandVelMM"); 
            velMinMax.add(velRightLR);
            oscP5.send(velMinMax, myAddress); 

            time2 = 0;
          }  

          if (velOutCount > 10) {              

            magnitudeRight = magRightPrev;

            OscMessage amountRight = new OscMessage("/amountRight");                          // Current hand size data (Vol_1) 
            amountRight.add(magnitudeRight);
            oscP5.send(amountRight, myAddress);
            //println("Volume: " + magnitudeRight);
          }

          if ((velOutCount > 6) && (velocityRightSum != 0)) {                                 // Calculate average hand velocity of movement towards OUT (VelAvg)

            velocityRightAvg = velocityRightSum / (velOutCount - 1);

            OscMessage velAvgOut = new OscMessage("/rightVelAvg"); 
            velAvgOut.add(velocityRightAvg);
            oscP5.send(velAvgOut, myAddress);

            //println("Average velocity OUT: " + velocityRightAvg);
          }

          velOutCount = 0;
          velocityRightSum = 0;
        }


        if ( (filSignalRight.x < (filSignalRightPrev.x - 0.8)) ) {                              // Movement towards IN

          if (velInCount > 0) {

            velocityRight = filButtSignalRight.mag();
            jerkinessRight = rightJerkVector.mag();
            velocityRightSum += velocityRight;
          }

          velInCount += 1;

          if (jerkinessRight > jerkinessRightPrev) {                                           // Detection of max jerkiness IN
            jerkinessRightMax = jerkinessRight;
          }

          if ((jerkinessRight < 0.45 * jerkinessRightMax) && (velOutCount == 0) /*&& (jerkCount == 0)*/) {

            OscMessage maxJekryIn = new OscMessage("/jerkMax"); 
            maxJekryIn.add(jerkinessRightMax);
            oscP5.send(maxJekryIn, myAddress);

            //println("Max jerkiness: " + jerkinessRightMax);

            //jerkinessFunc(jerkinessRightMax);
            //jerkCount = 1;
          }  


          velocityRightSample = velocityRight;

          if (velocityRightSample > velocityRightSamplePrev) {
            velocityRightMax = velocityRightSample;
          }

          if ((velocityRightSample < velocityRightMax * 0.7) && (jerkinessIndex <= 3) && (velTrig == 0) && (velInCount > 10)) {     // Detecting velocity IN movement (VelMax)

            if ( ((velocityRightMax > velocityRightMaxPrev * 0.35) && (velocityRightMax < velocityRightMaxPrev * 1.7)) || velocityRightMax == 0 ) {  

              //println("Max velocity IN: " + velocityRightMax);

              OscMessage rightHandVelocity = new OscMessage("/rightHandVelMax");                     
              rightHandVelocity.add(velocityRightMax);
              oscP5.send(rightHandVelocity, myAddress);
              velTrig = 1;
            }
          }

          velocityRightSamplePrev = velocityRightSample;
        }


        if ( (filSignalRight.x > (filSignalRightPrev.x + 0.4)) && (dir == 0) ) {                 //Left minimum of movement + 0.8

          velTrig = 0;
          velocityRightSamplePrev = 0;
          velocityRightMax = 0.0;
          velocityRightMaxPrev = 0.0;
          jerkinessRightMax = 0;
          jerkCount = 0;

          //println("Direction left: " + dir);

          if (time2 == 0) {
            time2 = millis();
          } else {
            time2 = 0;
          }

          if ( (time1 != 0) && (time2 != 0) && (velInCount > 6)) {                          //Calculate time difference in MIN position

            timeDiff = time2 - time1;

            velRightLR = ( 1 / timeDiff ) * 1000;

            //println("Min pos vel: " + velRightLR);
            //println("Vel IN count: " + velInCount);
            //println("--------------------------");
            //println("time2= "+ time2 + " time1= " + time1);

            //println("Time difference min: " + timeDiff);
            //println("VelInCount: " + velInCount);

            OscMessage velMinMax = new OscMessage("/rightHandVelMM"); 
            velMinMax.add(velRightLR);
            oscP5.send(velMinMax, myAddress);     

            time1 = 0;
          }

          if ( (velInCount > 6) && (velocityRightSum != 0) ) {                              // Calculate average hand velocity of movement towards IN (VelAvg)

            velocityRightAvg = velocityRightSum / (velInCount - 1);

            OscMessage velAvgOut = new OscMessage("/rightVelAvg"); 
            velAvgOut.add(velocityRightAvg);
            oscP5.send(velAvgOut, myAddress);

            //println("Average velocity MIN: " + velocityRightAvg);
            //println("------------------------------");
          }
          dir = 1;
          velInCount = 0;
          velocityRightSum = 0;
        }

        if (filSignalRight.x > (filSignalRightPrev.x + 0.8)) {                                //Movement towards out

          if (velOutCount > 0) {

            velocityRight2 = rightSpeedVector.mag(); 
            jerkinessRight = rightJerkVector2.mag();
            velocityRightSum += velocityRight2;
          }

          velOutCount += 1;  

          if (jerkinessRight > jerkinessRightPrev) {           // Detection of max jerkiness OUT
            jerkinessRightMax = jerkinessRight;
          }

          if ( (jerkinessRight < 0.45 * jerkinessRightMax) && (velInCount == 0) /*&& (jerkCount == 0)*/ ) {

            OscMessage maxJekryOut = new OscMessage("/jerkMax"); 
            maxJekryOut.add(jerkinessRightMax);
            oscP5.send(maxJekryOut, myAddress);

            //println("Max jerkiness OUT: " + jerkinessRightMax);

            //jerkinessFunc(jerkinessRightMax);
            //jerkCount = 1;
          }  


          velocityRightSample = velocityRight2;
          velocityRight2 = 0; 

          if (velocityRightSample > velocityRightSamplePrev) {                                  
            velocityRightMax = velocityRightSample;
          }


          if ((velocityRightSample < velocityRightMax * 0.7) && (jerkinessIndex <= 3) && (velTrig == 0) && (velOutCount > 10)) {     // Detecting velocity OUT movement (VelMax)

            if ( ((velocityRightMax > velocityRightMaxPrev * 0.35) && (velocityRightMax < velocityRightMaxPrev * 1.7)) || velocityRightMax == 0 ) {  

              //println("Max velocity IN: " + velocityRightMax);

              OscMessage rightHandVelocity = new OscMessage("/rightHandVelMax"); 
              rightHandVelocity.add(velocityRightMax);
              oscP5.send(rightHandVelocity, myAddress);
              velTrig = 1;
            }
          }

          velocityRightSamplePrev = velocityRightSample;
        } 

        OscMessage direction = new OscMessage("/dir"); 
        direction.add(dir);
        oscP5.send(direction, myAddress);  

        //println("Direction: " + dir);
        //println("Right x pos: " + filSignalRight.x);
        //println("Right x prev pos: " + filSignalRightPrev.x);
      } else {
        
        OscMessage startOn = new OscMessage("/start"); 
        startOn.add(start);
        oscP5.send(startOn, myAddress);
      }


      //drawBone(joints, KinectPV2.JointType_SpineMid, KinectPV2.JointType_ShoulderRight);
      //drawBone(joints, KinectPV2.JointType_ShoulderRight, KinectPV2.JointType_HandRight);
      //drawBone(joints, KinectPV2.JointType_SpineMid, KinectPV2.JointType_HandRight);


      //draw different color for each hand state
      drawHandState(joints[KinectPV2.JointType_HandRight]);
      //drawHandState(joints[KinectPV2.JointType_HandLeft]);
    }
  }  






  //stroke(255, 0, 0);                                                                                  // visualisation of some points and distances  
  //strokeWeight(6);                                                                                    // what is visualised changes all the time 
  //line(filSpineMid.x, filSpineMid.y, filSignalRight.x, filSignalRight.y);

  //stroke(0, 255, 0);
  //strokeWeight(2);
  //line(filSpineMid.x, filSpineMid.y, filRightShoulder.x, filRightShoulder.y);  

  //stroke(0, 255, 0);
  //strokeWeight(2);
  //line(filRightShoulder.x, filRightShoulder.y, filSignalRight.x, filSignalRight.y);
  
  

  //stroke(0,155,0);
  //strokeWeight(2);
  //line(orgSignalRight.x - 5, orgSignalRight.y - 5, orgSignalRightPrev.x - 5, orgSignalRightPrev.y - 5);

  //stroke(0,0,255);
  //strokeWeight(3);
  //line(spineMid.x, spineMid.y, filSignalRight.x, filSignalRight.y);


  //if (mousePressed) {
  //  background(255);
  //}
  
  orgSignalRightPrev5.set(filSignalRightPrev4);                            //  Setting the current values of data to be previous values in next frame
  orgSignalRightPrev4.set(filSignalRightPrev3);
  orgSignalRightPrev3.set(filSignalRightPrev2);
  orgSignalRightPrev2.set(filSignalRightPrev);
  orgSignalRightPrev.set(orgSignalRight);

  spineMidPrev.set(spineMid);

  filSignalRightPrev5.set(filSignalRightPrev4);
  filSignalRightPrev4.set(filSignalRightPrev3);
  filSignalRightPrev3.set(filSignalRightPrev2);
  filSignalRightPrev2.set(filSignalRightPrev);
  filSignalRightPrev.set(filSignalRight);

  
  centerHandPrev.set(centerHand);

  rightSpeedVectorPrev.set(rightSpeedVector);
  rightAccVectorPrev.set(rightAccVector);
  rightJerkVectorPrev.set(rightJerkVector);
  rightJerkVectorPrev2.set(rightJerkVector2);

  filButtSignalRightPrev.set(filButtSignalRight);
  rightJerkButtFiltPrev.set(rightJerkButtFilt); 
  
  magRightPrev = magRight;
  centerHandSizePrev = centerHandSize;

  jerkinessRightPrev = jerkinessRight;
  jerkinessRightPrev2 = jerkinessRight2;
  
  jerkRightPrev4 = jerkRightPrev3;
  jerkRightPrev3 = jerkRightPrev2;
  jerkRightPrev2 = jerkRightPrev;
  jerkRightPrev = jerkRight;
  
  jerkRightMaxPrev = jerkRightMax;

  velocityRightMaxPrev = velocityRightMax; 


  fill(255, 0, 0);
  text(frameRate, 50, 50);
}


//DRAW BODY
void drawBody(KJoint[] joints) {
  //drawBone(joints, KinectPV2.JointType_Head, KinectPV2.JointType_Neck);
  //drawBone(joints, KinectPV2.JointType_Neck, KinectPV2.JointType_SpineShoulder);
  //drawBone(joints, KinectPV2.JointType_SpineShoulder, KinectPV2.JointType_SpineMid);
  //drawBone(joints, KinectPV2.JointType_SpineMid, KinectPV2.JointType_SpineBase);
  //drawBone(joints, KinectPV2.JointType_SpineShoulder, KinectPV2.JointType_ShoulderRight);
  //drawBone(joints, KinectPV2.JointType_SpineShoulder, KinectPV2.JointType_ShoulderLeft);
  //drawBone(joints, KinectPV2.JointType_SpineBase, KinectPV2.JointType_HipRight);
  //drawBone(joints, KinectPV2.JointType_SpineBase, KinectPV2.JointType_HipLeft);

  // Right Arm
  drawBone(joints, KinectPV2.JointType_ShoulderRight, KinectPV2.JointType_ElbowRight);
  drawBone(joints, KinectPV2.JointType_ElbowRight, KinectPV2.JointType_WristRight);
  drawBone(joints, KinectPV2.JointType_WristRight, KinectPV2.JointType_HandRight);
  drawBone(joints, KinectPV2.JointType_HandRight, KinectPV2.JointType_HandTipRight);
  drawBone(joints, KinectPV2.JointType_WristRight, KinectPV2.JointType_ThumbRight);

  // Left Arm
  drawBone(joints, KinectPV2.JointType_ShoulderLeft, KinectPV2.JointType_ElbowLeft);
  drawBone(joints, KinectPV2.JointType_ElbowLeft, KinectPV2.JointType_WristLeft);
  drawBone(joints, KinectPV2.JointType_WristLeft, KinectPV2.JointType_HandLeft);
  drawBone(joints, KinectPV2.JointType_HandLeft, KinectPV2.JointType_HandTipLeft);
  drawBone(joints, KinectPV2.JointType_WristLeft, KinectPV2.JointType_ThumbLeft);

  //// Right Leg
  //drawBone(joints, KinectPV2.JointType_HipRight, KinectPV2.JointType_KneeRight);
  //drawBone(joints, KinectPV2.JointType_KneeRight, KinectPV2.JointType_AnkleRight);
  //drawBone(joints, KinectPV2.JointType_AnkleRight, KinectPV2.JointType_FootRight);

  //// Left Leg
  //drawBone(joints, KinectPV2.JointType_HipLeft, KinectPV2.JointType_KneeLeft);
  //drawBone(joints, KinectPV2.JointType_KneeLeft, KinectPV2.JointType_AnkleLeft);
  //drawBone(joints, KinectPV2.JointType_AnkleLeft, KinectPV2.JointType_FootLeft);

  drawJoint(joints, KinectPV2.JointType_HandTipLeft);
  drawJoint(joints, KinectPV2.JointType_HandTipRight);
  //drawJoint(joints, KinectPV2.JointType_FootLeft);
  //drawJoint(joints, KinectPV2.JointType_FootRight);

  //drawJoint(joints, KinectPV2.JointType_ThumbLeft);
  //drawJoint(joints, KinectPV2.JointType_ThumbRight);

  //drawJoint(joints, KinectPV2.JointType_Head);
}

// draw joint
void drawJoint(KJoint[] joints, int jointType) {
  pushMatrix();
  translate(joints[jointType].getX(), joints[jointType].getY(), joints[jointType].getZ());
  ellipse(0, 0, 25, 25);
  popMatrix();
}



// draw bone
void drawBone(KJoint[] joints, int jointType1, int jointType2) {
  pushMatrix();
  translate(joints[jointType1].getX(), joints[jointType1].getY(), joints[jointType1].getZ());
  ellipse(0, 0, 25, 25);
  popMatrix();
  line(joints[jointType1].getX(), joints[jointType1].getY(), joints[jointType1].getZ(), joints[jointType2].getX(), joints[jointType2].getY(), joints[jointType2].getZ());
}



//draw hand state
void drawHandState(KJoint joint) {
  noStroke();
  handState(joint.getState());
  pushMatrix();
  translate(joint.getX(), joint.getY());
  ellipse(0, 0, 70, 70);
  popMatrix();
}

/*
Different hand state
 KinectPV2.HandState_Open
 KinectPV2.HandState_Closed
 KinectPV2.HandState_Lasso
 KinectPV2.HandState_NotTracked
 */
void handState(int handState) {
  switch(handState) {
  case KinectPV2.HandState_Open:
    fill(0, 255, 0);
    break;
  case KinectPV2.HandState_Closed:
    fill(255, 0, 0);
    break;
  case KinectPV2.HandState_Lasso:
    fill(0, 0, 255);
    break;
  case KinectPV2.HandState_NotTracked:
    fill(255, 255, 255);
    break;
  }
}

void jerkinessFunc (float jerkiness) {                                                               // calssifying jerkiness and sending data to PDM   (Jerk_1)
  if (frameCount > 10) {

    if ((jerkiness > 0) && (jerkiness <= 25)) {
      jerkinessIndex = 0;
    }

    if ((jerkiness > 25) && (jerkiness <= 40)) {
      jerkinessIndex = 1;
    }

    if ((jerkiness > 40) && (jerkiness <= 70)) {
      jerkinessIndex = 2;
    }

    if ((jerkiness > 70) && (jerkiness <= 100)) {
      jerkinessIndex = 3;
    }

    if ((jerkiness > 100) && (jerkiness <= 130)) {
      jerkinessIndex = 4;
    }

    if ((jerkiness > 130) && (jerkiness <= 160)) {
      jerkinessIndex = 5;
    }

    if ((jerkiness > 160) && (jerkiness <= 190)) {
      jerkinessIndex = 6;
    }

    if ((jerkiness > 190) && (jerkiness <= 230)) {
      jerkinessIndex = 7;
    }

    if (jerkiness > 230) {
      jerkinessIndex = 8;
    }

    if (jerkinessIndex >= jerkinessIndexPrev) {
      if ((jerkinessIndex - jerkinessIndexPrev) <= 4) {

        //println("Right Jerkiness Rising: " + jerkinessIndex);

        OscMessage rightHandJerkiness = new OscMessage("/rightJerkiness"); 
        rightHandJerkiness.add(jerkinessIndex);
        oscP5.send(rightHandJerkiness, myAddress);

        jerkinessIndexPrev = jerkinessIndex;
      }
    } else {
      if ((jerkinessIndexPrev - jerkinessIndex) <= 3) {

        //println("Right Jerkiness Falling: " + jerkinessIndex);

        OscMessage rightHandJerkiness = new OscMessage("/rightJerkiness"); 
        rightHandJerkiness.add(jerkinessIndex);
        oscP5.send(rightHandJerkiness, myAddress);

        jerkinessIndexPrev = jerkinessIndex;
      }
    }
  }
}


float jerkinessFunc2 (float x, float x1, float x2, float x3) {                                // Function for calculating jerkiness --- third order finite difference (backward)
  float y = x -3 * x1 + 3 * x2 -x3;   
  return y;
}

PVector Butterworth (PVector x, PVector xPrev, PVector xFilPrev) {                             // First order Butterworth filter function
  //float _x = x;
  //float _xPrev = xPrev;
  //float _yPrev = yPrev;
  PVector xFil = new PVector();
  float cuttoff = 5;
  float sampleFreq = frameRate;

  float c = cos((3.14 * cuttoff) / sampleFreq) / sin((3.14159 * cuttoff)/ sampleFreq);
  float a = 1 + c;
  float a0 = 1 / a;
  float a1 = a0;
  float b1 = (1 - c) / a;

  float filX = a0 * x.x + a1 * xPrev.x - b1 * xFilPrev.x;
  float filY = a0 * x.y + a1 * xPrev.y - b1 * xFilPrev.y;

  xFil.set(filX, filY );

  return xFil;
}


float medianFilter(float x1, float x2, float x3, float x4, float x5) {                        // Function for Median filter

  float[] values = {x1, x2, x3, x4, x5};

  values = sort(values);
  float y = values[2];

  return y;
}


float movingAverage(float x1, float x2, float x3, float x4, float x5) {                        // Function for moving average filter

  float[] values = {x1, x2, x3, x4, x5};
  float y = 0.0; 

  for (int i = 0; i < values.length; i++) {
    y += values[i];
  }

  y = y / values.length;

  return y;
}